/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ses.v20201002.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ListBlackEmailAddressResponse extends AbstractModel {

    /**
    * List of blocklisted addresses.
    */
    @SerializedName("BlackList")
    @Expose
    private BlackEmailAddress [] BlackList;

    /**
    * Total number of blocklisted addresses.
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * The unique request ID, which is returned for each request. RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get List of blocklisted addresses. 
     * @return BlackList List of blocklisted addresses.
     */
    public BlackEmailAddress [] getBlackList() {
        return this.BlackList;
    }

    /**
     * Set List of blocklisted addresses.
     * @param BlackList List of blocklisted addresses.
     */
    public void setBlackList(BlackEmailAddress [] BlackList) {
        this.BlackList = BlackList;
    }

    /**
     * Get Total number of blocklisted addresses. 
     * @return TotalCount Total number of blocklisted addresses.
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number of blocklisted addresses.
     * @param TotalCount Total number of blocklisted addresses.
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get The unique request ID, which is returned for each request. RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     * @param RequestId The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public ListBlackEmailAddressResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ListBlackEmailAddressResponse(ListBlackEmailAddressResponse source) {
        if (source.BlackList != null) {
            this.BlackList = new BlackEmailAddress[source.BlackList.length];
            for (int i = 0; i < source.BlackList.length; i++) {
                this.BlackList[i] = new BlackEmailAddress(source.BlackList[i]);
            }
        }
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "BlackList.", this.BlackList);
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

