/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.sqlserver.v20180328.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeBackupMonitorResponse extends AbstractModel {

    /**
    * Backup trend chart timeline.
    */
    @SerializedName("TimeStamp")
    @Expose
    private String [] TimeStamp;

    /**
    * Free backup space.
    */
    @SerializedName("FreeSpace")
    @Expose
    private Float [] FreeSpace;

    /**
    * Actual total backup space.
    */
    @SerializedName("ActualUsedSpace")
    @Expose
    private Float [] ActualUsedSpace;

    /**
    * Backup space for logs.
    */
    @SerializedName("LogBackupSpace")
    @Expose
    private Float [] LogBackupSpace;

    /**
    * Backup space for data.
    */
    @SerializedName("DataBackupSpace")
    @Expose
    private Float [] DataBackupSpace;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Backup trend chart timeline. 
     * @return TimeStamp Backup trend chart timeline.
     */
    public String [] getTimeStamp() {
        return this.TimeStamp;
    }

    /**
     * Set Backup trend chart timeline.
     * @param TimeStamp Backup trend chart timeline.
     */
    public void setTimeStamp(String [] TimeStamp) {
        this.TimeStamp = TimeStamp;
    }

    /**
     * Get Free backup space. 
     * @return FreeSpace Free backup space.
     */
    public Float [] getFreeSpace() {
        return this.FreeSpace;
    }

    /**
     * Set Free backup space.
     * @param FreeSpace Free backup space.
     */
    public void setFreeSpace(Float [] FreeSpace) {
        this.FreeSpace = FreeSpace;
    }

    /**
     * Get Actual total backup space. 
     * @return ActualUsedSpace Actual total backup space.
     */
    public Float [] getActualUsedSpace() {
        return this.ActualUsedSpace;
    }

    /**
     * Set Actual total backup space.
     * @param ActualUsedSpace Actual total backup space.
     */
    public void setActualUsedSpace(Float [] ActualUsedSpace) {
        this.ActualUsedSpace = ActualUsedSpace;
    }

    /**
     * Get Backup space for logs. 
     * @return LogBackupSpace Backup space for logs.
     */
    public Float [] getLogBackupSpace() {
        return this.LogBackupSpace;
    }

    /**
     * Set Backup space for logs.
     * @param LogBackupSpace Backup space for logs.
     */
    public void setLogBackupSpace(Float [] LogBackupSpace) {
        this.LogBackupSpace = LogBackupSpace;
    }

    /**
     * Get Backup space for data. 
     * @return DataBackupSpace Backup space for data.
     */
    public Float [] getDataBackupSpace() {
        return this.DataBackupSpace;
    }

    /**
     * Set Backup space for data.
     * @param DataBackupSpace Backup space for data.
     */
    public void setDataBackupSpace(Float [] DataBackupSpace) {
        this.DataBackupSpace = DataBackupSpace;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeBackupMonitorResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeBackupMonitorResponse(DescribeBackupMonitorResponse source) {
        if (source.TimeStamp != null) {
            this.TimeStamp = new String[source.TimeStamp.length];
            for (int i = 0; i < source.TimeStamp.length; i++) {
                this.TimeStamp[i] = new String(source.TimeStamp[i]);
            }
        }
        if (source.FreeSpace != null) {
            this.FreeSpace = new Float[source.FreeSpace.length];
            for (int i = 0; i < source.FreeSpace.length; i++) {
                this.FreeSpace[i] = new Float(source.FreeSpace[i]);
            }
        }
        if (source.ActualUsedSpace != null) {
            this.ActualUsedSpace = new Float[source.ActualUsedSpace.length];
            for (int i = 0; i < source.ActualUsedSpace.length; i++) {
                this.ActualUsedSpace[i] = new Float(source.ActualUsedSpace[i]);
            }
        }
        if (source.LogBackupSpace != null) {
            this.LogBackupSpace = new Float[source.LogBackupSpace.length];
            for (int i = 0; i < source.LogBackupSpace.length; i++) {
                this.LogBackupSpace[i] = new Float(source.LogBackupSpace[i]);
            }
        }
        if (source.DataBackupSpace != null) {
            this.DataBackupSpace = new Float[source.DataBackupSpace.length];
            for (int i = 0; i < source.DataBackupSpace.length; i++) {
                this.DataBackupSpace[i] = new Float(source.DataBackupSpace[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "TimeStamp.", this.TimeStamp);
        this.setParamArraySimple(map, prefix + "FreeSpace.", this.FreeSpace);
        this.setParamArraySimple(map, prefix + "ActualUsedSpace.", this.ActualUsedSpace);
        this.setParamArraySimple(map, prefix + "LogBackupSpace.", this.LogBackupSpace);
        this.setParamArraySimple(map, prefix + "DataBackupSpace.", this.DataBackupSpace);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

