/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.sqlserver.v20180328.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeBackupSummaryResponse extends AbstractModel {

    /**
    * Actual free total space, in KB.
    */
    @SerializedName("FreeSpace")
    @Expose
    private Long FreeSpace;

    /**
    * Actual used space of backups, in KB.
    */
    @SerializedName("ActualUsedSpace")
    @Expose
    private Long ActualUsedSpace;

    /**
    * Total number of backup files.
    */
    @SerializedName("BackupFilesTotal")
    @Expose
    private Long BackupFilesTotal;

    /**
    * Charged space of the space occupied by backups, in KB.
    */
    @SerializedName("BillingSpace")
    @Expose
    private Long BillingSpace;

    /**
    * Data backup usage space, in KB.
    */
    @SerializedName("DataBackupSpace")
    @Expose
    private Long DataBackupSpace;

    /**
    * Total number of data backup files.
    */
    @SerializedName("DataBackupCount")
    @Expose
    private Long DataBackupCount;

    /**
    * Storage space used by manual backups in data backup, in KB.
    */
    @SerializedName("ManualBackupSpace")
    @Expose
    private Long ManualBackupSpace;

    /**
    * Total number of files for manual backups in data backup.
    */
    @SerializedName("ManualBackupCount")
    @Expose
    private Long ManualBackupCount;

    /**
    * Storage space used by automatic backups in data backup, in KB.
    */
    @SerializedName("AutoBackupSpace")
    @Expose
    private Long AutoBackupSpace;

    /**
    * Total number of files for automatic backups in data backup.
    */
    @SerializedName("AutoBackupCount")
    @Expose
    private Long AutoBackupCount;

    /**
    * Backup usage space for logs, in KB.
    */
    @SerializedName("LogBackupSpace")
    @Expose
    private Long LogBackupSpace;

    /**
    * Total number of log backup files.
    */
    @SerializedName("LogBackupCount")
    @Expose
    private Long LogBackupCount;

    /**
    * Estimated fees, in USD/hour.
    */
    @SerializedName("EstimatedAmount")
    @Expose
    private Float EstimatedAmount;

    /**
    * Total number of local backup files.
    */
    @SerializedName("LocalBackupFilesTotal")
    @Expose
    private Long LocalBackupFilesTotal;

    /**
    * Total number of cross-region backup files.
    */
    @SerializedName("CrossBackupFilesTotal")
    @Expose
    private Long CrossBackupFilesTotal;

    /**
    * Charged space of the space occupied by cross-region backups, in KB.
    */
    @SerializedName("CrossBillingSpace")
    @Expose
    private Long CrossBillingSpace;

    /**
    * Space used by cross-region automatic data backups, in KB.
    */
    @SerializedName("CrossAutoBackupSpace")
    @Expose
    private Long CrossAutoBackupSpace;

    /**
    * Total number of files for cross-region automatic data backups.
    */
    @SerializedName("CrossAutoBackupCount")
    @Expose
    private Long CrossAutoBackupCount;

    /**
    * Space used by local log backups, in KB.
    */
    @SerializedName("LocalLogBackupSpace")
    @Expose
    private Long LocalLogBackupSpace;

    /**
    * Total number of files for local log backups.
    */
    @SerializedName("LocalLogBackupCount")
    @Expose
    private Long LocalLogBackupCount;

    /**
    * Space used by cross-region log backups, in KB.
    */
    @SerializedName("CrossLogBackupSpace")
    @Expose
    private Long CrossLogBackupSpace;

    /**
    * Total number of files for cross-region log backups.
    */
    @SerializedName("CrossLogBackupCount")
    @Expose
    private Long CrossLogBackupCount;

    /**
    * Estimated fees for cross-region backups, in USD/hour.
    */
    @SerializedName("CrossEstimatedAmount")
    @Expose
    private Float CrossEstimatedAmount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Actual free total space, in KB. 
     * @return FreeSpace Actual free total space, in KB.
     */
    public Long getFreeSpace() {
        return this.FreeSpace;
    }

    /**
     * Set Actual free total space, in KB.
     * @param FreeSpace Actual free total space, in KB.
     */
    public void setFreeSpace(Long FreeSpace) {
        this.FreeSpace = FreeSpace;
    }

    /**
     * Get Actual used space of backups, in KB. 
     * @return ActualUsedSpace Actual used space of backups, in KB.
     */
    public Long getActualUsedSpace() {
        return this.ActualUsedSpace;
    }

    /**
     * Set Actual used space of backups, in KB.
     * @param ActualUsedSpace Actual used space of backups, in KB.
     */
    public void setActualUsedSpace(Long ActualUsedSpace) {
        this.ActualUsedSpace = ActualUsedSpace;
    }

    /**
     * Get Total number of backup files. 
     * @return BackupFilesTotal Total number of backup files.
     */
    public Long getBackupFilesTotal() {
        return this.BackupFilesTotal;
    }

    /**
     * Set Total number of backup files.
     * @param BackupFilesTotal Total number of backup files.
     */
    public void setBackupFilesTotal(Long BackupFilesTotal) {
        this.BackupFilesTotal = BackupFilesTotal;
    }

    /**
     * Get Charged space of the space occupied by backups, in KB. 
     * @return BillingSpace Charged space of the space occupied by backups, in KB.
     */
    public Long getBillingSpace() {
        return this.BillingSpace;
    }

    /**
     * Set Charged space of the space occupied by backups, in KB.
     * @param BillingSpace Charged space of the space occupied by backups, in KB.
     */
    public void setBillingSpace(Long BillingSpace) {
        this.BillingSpace = BillingSpace;
    }

    /**
     * Get Data backup usage space, in KB. 
     * @return DataBackupSpace Data backup usage space, in KB.
     */
    public Long getDataBackupSpace() {
        return this.DataBackupSpace;
    }

    /**
     * Set Data backup usage space, in KB.
     * @param DataBackupSpace Data backup usage space, in KB.
     */
    public void setDataBackupSpace(Long DataBackupSpace) {
        this.DataBackupSpace = DataBackupSpace;
    }

    /**
     * Get Total number of data backup files. 
     * @return DataBackupCount Total number of data backup files.
     */
    public Long getDataBackupCount() {
        return this.DataBackupCount;
    }

    /**
     * Set Total number of data backup files.
     * @param DataBackupCount Total number of data backup files.
     */
    public void setDataBackupCount(Long DataBackupCount) {
        this.DataBackupCount = DataBackupCount;
    }

    /**
     * Get Storage space used by manual backups in data backup, in KB. 
     * @return ManualBackupSpace Storage space used by manual backups in data backup, in KB.
     */
    public Long getManualBackupSpace() {
        return this.ManualBackupSpace;
    }

    /**
     * Set Storage space used by manual backups in data backup, in KB.
     * @param ManualBackupSpace Storage space used by manual backups in data backup, in KB.
     */
    public void setManualBackupSpace(Long ManualBackupSpace) {
        this.ManualBackupSpace = ManualBackupSpace;
    }

    /**
     * Get Total number of files for manual backups in data backup. 
     * @return ManualBackupCount Total number of files for manual backups in data backup.
     */
    public Long getManualBackupCount() {
        return this.ManualBackupCount;
    }

    /**
     * Set Total number of files for manual backups in data backup.
     * @param ManualBackupCount Total number of files for manual backups in data backup.
     */
    public void setManualBackupCount(Long ManualBackupCount) {
        this.ManualBackupCount = ManualBackupCount;
    }

    /**
     * Get Storage space used by automatic backups in data backup, in KB. 
     * @return AutoBackupSpace Storage space used by automatic backups in data backup, in KB.
     */
    public Long getAutoBackupSpace() {
        return this.AutoBackupSpace;
    }

    /**
     * Set Storage space used by automatic backups in data backup, in KB.
     * @param AutoBackupSpace Storage space used by automatic backups in data backup, in KB.
     */
    public void setAutoBackupSpace(Long AutoBackupSpace) {
        this.AutoBackupSpace = AutoBackupSpace;
    }

    /**
     * Get Total number of files for automatic backups in data backup. 
     * @return AutoBackupCount Total number of files for automatic backups in data backup.
     */
    public Long getAutoBackupCount() {
        return this.AutoBackupCount;
    }

    /**
     * Set Total number of files for automatic backups in data backup.
     * @param AutoBackupCount Total number of files for automatic backups in data backup.
     */
    public void setAutoBackupCount(Long AutoBackupCount) {
        this.AutoBackupCount = AutoBackupCount;
    }

    /**
     * Get Backup usage space for logs, in KB. 
     * @return LogBackupSpace Backup usage space for logs, in KB.
     */
    public Long getLogBackupSpace() {
        return this.LogBackupSpace;
    }

    /**
     * Set Backup usage space for logs, in KB.
     * @param LogBackupSpace Backup usage space for logs, in KB.
     */
    public void setLogBackupSpace(Long LogBackupSpace) {
        this.LogBackupSpace = LogBackupSpace;
    }

    /**
     * Get Total number of log backup files. 
     * @return LogBackupCount Total number of log backup files.
     */
    public Long getLogBackupCount() {
        return this.LogBackupCount;
    }

    /**
     * Set Total number of log backup files.
     * @param LogBackupCount Total number of log backup files.
     */
    public void setLogBackupCount(Long LogBackupCount) {
        this.LogBackupCount = LogBackupCount;
    }

    /**
     * Get Estimated fees, in USD/hour. 
     * @return EstimatedAmount Estimated fees, in USD/hour.
     */
    public Float getEstimatedAmount() {
        return this.EstimatedAmount;
    }

    /**
     * Set Estimated fees, in USD/hour.
     * @param EstimatedAmount Estimated fees, in USD/hour.
     */
    public void setEstimatedAmount(Float EstimatedAmount) {
        this.EstimatedAmount = EstimatedAmount;
    }

    /**
     * Get Total number of local backup files. 
     * @return LocalBackupFilesTotal Total number of local backup files.
     */
    public Long getLocalBackupFilesTotal() {
        return this.LocalBackupFilesTotal;
    }

    /**
     * Set Total number of local backup files.
     * @param LocalBackupFilesTotal Total number of local backup files.
     */
    public void setLocalBackupFilesTotal(Long LocalBackupFilesTotal) {
        this.LocalBackupFilesTotal = LocalBackupFilesTotal;
    }

    /**
     * Get Total number of cross-region backup files. 
     * @return CrossBackupFilesTotal Total number of cross-region backup files.
     */
    public Long getCrossBackupFilesTotal() {
        return this.CrossBackupFilesTotal;
    }

    /**
     * Set Total number of cross-region backup files.
     * @param CrossBackupFilesTotal Total number of cross-region backup files.
     */
    public void setCrossBackupFilesTotal(Long CrossBackupFilesTotal) {
        this.CrossBackupFilesTotal = CrossBackupFilesTotal;
    }

    /**
     * Get Charged space of the space occupied by cross-region backups, in KB. 
     * @return CrossBillingSpace Charged space of the space occupied by cross-region backups, in KB.
     */
    public Long getCrossBillingSpace() {
        return this.CrossBillingSpace;
    }

    /**
     * Set Charged space of the space occupied by cross-region backups, in KB.
     * @param CrossBillingSpace Charged space of the space occupied by cross-region backups, in KB.
     */
    public void setCrossBillingSpace(Long CrossBillingSpace) {
        this.CrossBillingSpace = CrossBillingSpace;
    }

    /**
     * Get Space used by cross-region automatic data backups, in KB. 
     * @return CrossAutoBackupSpace Space used by cross-region automatic data backups, in KB.
     */
    public Long getCrossAutoBackupSpace() {
        return this.CrossAutoBackupSpace;
    }

    /**
     * Set Space used by cross-region automatic data backups, in KB.
     * @param CrossAutoBackupSpace Space used by cross-region automatic data backups, in KB.
     */
    public void setCrossAutoBackupSpace(Long CrossAutoBackupSpace) {
        this.CrossAutoBackupSpace = CrossAutoBackupSpace;
    }

    /**
     * Get Total number of files for cross-region automatic data backups. 
     * @return CrossAutoBackupCount Total number of files for cross-region automatic data backups.
     */
    public Long getCrossAutoBackupCount() {
        return this.CrossAutoBackupCount;
    }

    /**
     * Set Total number of files for cross-region automatic data backups.
     * @param CrossAutoBackupCount Total number of files for cross-region automatic data backups.
     */
    public void setCrossAutoBackupCount(Long CrossAutoBackupCount) {
        this.CrossAutoBackupCount = CrossAutoBackupCount;
    }

    /**
     * Get Space used by local log backups, in KB. 
     * @return LocalLogBackupSpace Space used by local log backups, in KB.
     */
    public Long getLocalLogBackupSpace() {
        return this.LocalLogBackupSpace;
    }

    /**
     * Set Space used by local log backups, in KB.
     * @param LocalLogBackupSpace Space used by local log backups, in KB.
     */
    public void setLocalLogBackupSpace(Long LocalLogBackupSpace) {
        this.LocalLogBackupSpace = LocalLogBackupSpace;
    }

    /**
     * Get Total number of files for local log backups. 
     * @return LocalLogBackupCount Total number of files for local log backups.
     */
    public Long getLocalLogBackupCount() {
        return this.LocalLogBackupCount;
    }

    /**
     * Set Total number of files for local log backups.
     * @param LocalLogBackupCount Total number of files for local log backups.
     */
    public void setLocalLogBackupCount(Long LocalLogBackupCount) {
        this.LocalLogBackupCount = LocalLogBackupCount;
    }

    /**
     * Get Space used by cross-region log backups, in KB. 
     * @return CrossLogBackupSpace Space used by cross-region log backups, in KB.
     */
    public Long getCrossLogBackupSpace() {
        return this.CrossLogBackupSpace;
    }

    /**
     * Set Space used by cross-region log backups, in KB.
     * @param CrossLogBackupSpace Space used by cross-region log backups, in KB.
     */
    public void setCrossLogBackupSpace(Long CrossLogBackupSpace) {
        this.CrossLogBackupSpace = CrossLogBackupSpace;
    }

    /**
     * Get Total number of files for cross-region log backups. 
     * @return CrossLogBackupCount Total number of files for cross-region log backups.
     */
    public Long getCrossLogBackupCount() {
        return this.CrossLogBackupCount;
    }

    /**
     * Set Total number of files for cross-region log backups.
     * @param CrossLogBackupCount Total number of files for cross-region log backups.
     */
    public void setCrossLogBackupCount(Long CrossLogBackupCount) {
        this.CrossLogBackupCount = CrossLogBackupCount;
    }

    /**
     * Get Estimated fees for cross-region backups, in USD/hour. 
     * @return CrossEstimatedAmount Estimated fees for cross-region backups, in USD/hour.
     */
    public Float getCrossEstimatedAmount() {
        return this.CrossEstimatedAmount;
    }

    /**
     * Set Estimated fees for cross-region backups, in USD/hour.
     * @param CrossEstimatedAmount Estimated fees for cross-region backups, in USD/hour.
     */
    public void setCrossEstimatedAmount(Float CrossEstimatedAmount) {
        this.CrossEstimatedAmount = CrossEstimatedAmount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeBackupSummaryResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeBackupSummaryResponse(DescribeBackupSummaryResponse source) {
        if (source.FreeSpace != null) {
            this.FreeSpace = new Long(source.FreeSpace);
        }
        if (source.ActualUsedSpace != null) {
            this.ActualUsedSpace = new Long(source.ActualUsedSpace);
        }
        if (source.BackupFilesTotal != null) {
            this.BackupFilesTotal = new Long(source.BackupFilesTotal);
        }
        if (source.BillingSpace != null) {
            this.BillingSpace = new Long(source.BillingSpace);
        }
        if (source.DataBackupSpace != null) {
            this.DataBackupSpace = new Long(source.DataBackupSpace);
        }
        if (source.DataBackupCount != null) {
            this.DataBackupCount = new Long(source.DataBackupCount);
        }
        if (source.ManualBackupSpace != null) {
            this.ManualBackupSpace = new Long(source.ManualBackupSpace);
        }
        if (source.ManualBackupCount != null) {
            this.ManualBackupCount = new Long(source.ManualBackupCount);
        }
        if (source.AutoBackupSpace != null) {
            this.AutoBackupSpace = new Long(source.AutoBackupSpace);
        }
        if (source.AutoBackupCount != null) {
            this.AutoBackupCount = new Long(source.AutoBackupCount);
        }
        if (source.LogBackupSpace != null) {
            this.LogBackupSpace = new Long(source.LogBackupSpace);
        }
        if (source.LogBackupCount != null) {
            this.LogBackupCount = new Long(source.LogBackupCount);
        }
        if (source.EstimatedAmount != null) {
            this.EstimatedAmount = new Float(source.EstimatedAmount);
        }
        if (source.LocalBackupFilesTotal != null) {
            this.LocalBackupFilesTotal = new Long(source.LocalBackupFilesTotal);
        }
        if (source.CrossBackupFilesTotal != null) {
            this.CrossBackupFilesTotal = new Long(source.CrossBackupFilesTotal);
        }
        if (source.CrossBillingSpace != null) {
            this.CrossBillingSpace = new Long(source.CrossBillingSpace);
        }
        if (source.CrossAutoBackupSpace != null) {
            this.CrossAutoBackupSpace = new Long(source.CrossAutoBackupSpace);
        }
        if (source.CrossAutoBackupCount != null) {
            this.CrossAutoBackupCount = new Long(source.CrossAutoBackupCount);
        }
        if (source.LocalLogBackupSpace != null) {
            this.LocalLogBackupSpace = new Long(source.LocalLogBackupSpace);
        }
        if (source.LocalLogBackupCount != null) {
            this.LocalLogBackupCount = new Long(source.LocalLogBackupCount);
        }
        if (source.CrossLogBackupSpace != null) {
            this.CrossLogBackupSpace = new Long(source.CrossLogBackupSpace);
        }
        if (source.CrossLogBackupCount != null) {
            this.CrossLogBackupCount = new Long(source.CrossLogBackupCount);
        }
        if (source.CrossEstimatedAmount != null) {
            this.CrossEstimatedAmount = new Float(source.CrossEstimatedAmount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "FreeSpace", this.FreeSpace);
        this.setParamSimple(map, prefix + "ActualUsedSpace", this.ActualUsedSpace);
        this.setParamSimple(map, prefix + "BackupFilesTotal", this.BackupFilesTotal);
        this.setParamSimple(map, prefix + "BillingSpace", this.BillingSpace);
        this.setParamSimple(map, prefix + "DataBackupSpace", this.DataBackupSpace);
        this.setParamSimple(map, prefix + "DataBackupCount", this.DataBackupCount);
        this.setParamSimple(map, prefix + "ManualBackupSpace", this.ManualBackupSpace);
        this.setParamSimple(map, prefix + "ManualBackupCount", this.ManualBackupCount);
        this.setParamSimple(map, prefix + "AutoBackupSpace", this.AutoBackupSpace);
        this.setParamSimple(map, prefix + "AutoBackupCount", this.AutoBackupCount);
        this.setParamSimple(map, prefix + "LogBackupSpace", this.LogBackupSpace);
        this.setParamSimple(map, prefix + "LogBackupCount", this.LogBackupCount);
        this.setParamSimple(map, prefix + "EstimatedAmount", this.EstimatedAmount);
        this.setParamSimple(map, prefix + "LocalBackupFilesTotal", this.LocalBackupFilesTotal);
        this.setParamSimple(map, prefix + "CrossBackupFilesTotal", this.CrossBackupFilesTotal);
        this.setParamSimple(map, prefix + "CrossBillingSpace", this.CrossBillingSpace);
        this.setParamSimple(map, prefix + "CrossAutoBackupSpace", this.CrossAutoBackupSpace);
        this.setParamSimple(map, prefix + "CrossAutoBackupCount", this.CrossAutoBackupCount);
        this.setParamSimple(map, prefix + "LocalLogBackupSpace", this.LocalLogBackupSpace);
        this.setParamSimple(map, prefix + "LocalLogBackupCount", this.LocalLogBackupCount);
        this.setParamSimple(map, prefix + "CrossLogBackupSpace", this.CrossLogBackupSpace);
        this.setParamSimple(map, prefix + "CrossLogBackupCount", this.CrossLogBackupCount);
        this.setParamSimple(map, prefix + "CrossEstimatedAmount", this.CrossEstimatedAmount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

