/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.sqlserver.v20180328.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeCollationTimeZoneResponse extends AbstractModel {

    /**
    * System character set collation list.
    */
    @SerializedName("Collation")
    @Expose
    private String [] Collation;

    /**
    * System time zone list.
    */
    @SerializedName("TimeZone")
    @Expose
    private String [] TimeZone;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get System character set collation list. 
     * @return Collation System character set collation list.
     */
    public String [] getCollation() {
        return this.Collation;
    }

    /**
     * Set System character set collation list.
     * @param Collation System character set collation list.
     */
    public void setCollation(String [] Collation) {
        this.Collation = Collation;
    }

    /**
     * Get System time zone list. 
     * @return TimeZone System time zone list.
     */
    public String [] getTimeZone() {
        return this.TimeZone;
    }

    /**
     * Set System time zone list.
     * @param TimeZone System time zone list.
     */
    public void setTimeZone(String [] TimeZone) {
        this.TimeZone = TimeZone;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeCollationTimeZoneResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeCollationTimeZoneResponse(DescribeCollationTimeZoneResponse source) {
        if (source.Collation != null) {
            this.Collation = new String[source.Collation.length];
            for (int i = 0; i < source.Collation.length; i++) {
                this.Collation[i] = new String(source.Collation[i]);
            }
        }
        if (source.TimeZone != null) {
            this.TimeZone = new String[source.TimeZone.length];
            for (int i = 0; i < source.TimeZone.length; i++) {
                this.TimeZone[i] = new String(source.TimeZone[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "Collation.", this.Collation);
        this.setParamArraySimple(map, prefix + "TimeZone.", this.TimeZone);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

