/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.sqlserver.v20180328.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeDatabaseNamesResponse extends AbstractModel {

    /**
    * Total number of databases associated with the account.
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Database name set.
    */
    @SerializedName("DatabaseNameSet")
    @Expose
    private String [] DatabaseNameSet;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of databases associated with the account. 
     * @return TotalCount Total number of databases associated with the account.
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number of databases associated with the account.
     * @param TotalCount Total number of databases associated with the account.
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Database name set. 
     * @return DatabaseNameSet Database name set.
     */
    public String [] getDatabaseNameSet() {
        return this.DatabaseNameSet;
    }

    /**
     * Set Database name set.
     * @param DatabaseNameSet Database name set.
     */
    public void setDatabaseNameSet(String [] DatabaseNameSet) {
        this.DatabaseNameSet = DatabaseNameSet;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeDatabaseNamesResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeDatabaseNamesResponse(DescribeDatabaseNamesResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.DatabaseNameSet != null) {
            this.DatabaseNameSet = new String[source.DatabaseNameSet.length];
            for (int i = 0; i < source.DatabaseNameSet.length; i++) {
                this.DatabaseNameSet[i] = new String(source.DatabaseNameSet[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArraySimple(map, prefix + "DatabaseNameSet.", this.DatabaseNameSet);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

