/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.sqlserver.v20180328.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeReadOnlyGroupByReadOnlyInstanceResponse extends AbstractModel {

    /**
    * Read only group ID.
    */
    @SerializedName("ReadOnlyGroupId")
    @Expose
    private String ReadOnlyGroupId;

    /**
    * Read-only group name.
    */
    @SerializedName("ReadOnlyGroupName")
    @Expose
    private String ReadOnlyGroupName;

    /**
    * Region ID of the read-only group.
    */
    @SerializedName("RegionId")
    @Expose
    private String RegionId;

    /**
    * AZ ID of the read-only group.
    */
    @SerializedName("ZoneId")
    @Expose
    private String ZoneId;

    /**
    * Whether to enable startup timeout elimination, 0 - disable removal, 1 - enable removal.
    */
    @SerializedName("IsOfflineDelay")
    @Expose
    private Long IsOfflineDelay;

    /**
    * Timeout threshold used after the delayed read-only instance removal feature is enabled, in seconds.
    */
    @SerializedName("ReadOnlyMaxDelayTime")
    @Expose
    private Long ReadOnlyMaxDelayTime;

    /**
    * Minimum number of retained read-only replicas in the read-only group, after the delayed read-only instance removal feature is enabled.
    */
    @SerializedName("MinReadOnlyInGroup")
    @Expose
    private Long MinReadOnlyInGroup;

    /**
    * Read-only group VIP.
    */
    @SerializedName("Vip")
    @Expose
    private String Vip;

    /**
    * Read-only group VPort.
    */
    @SerializedName("Vport")
    @Expose
    private Long Vport;

    /**
    * VPC ID of the read-only group.
    */
    @SerializedName("VpcId")
    @Expose
    private String VpcId;

    /**
    * VPC subnet ID of the read-only group.
    */
    @SerializedName("SubnetId")
    @Expose
    private String SubnetId;

    /**
    * Primary instance ID. For example, mssql-sgeshe3th.
    */
    @SerializedName("MasterInstanceId")
    @Expose
    private String MasterInstanceId;

    /**
    * Region ID of the primary instance.
    */
    @SerializedName("MasterRegionId")
    @Expose
    private String MasterRegionId;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Read only group ID. 
     * @return ReadOnlyGroupId Read only group ID.
     */
    public String getReadOnlyGroupId() {
        return this.ReadOnlyGroupId;
    }

    /**
     * Set Read only group ID.
     * @param ReadOnlyGroupId Read only group ID.
     */
    public void setReadOnlyGroupId(String ReadOnlyGroupId) {
        this.ReadOnlyGroupId = ReadOnlyGroupId;
    }

    /**
     * Get Read-only group name. 
     * @return ReadOnlyGroupName Read-only group name.
     */
    public String getReadOnlyGroupName() {
        return this.ReadOnlyGroupName;
    }

    /**
     * Set Read-only group name.
     * @param ReadOnlyGroupName Read-only group name.
     */
    public void setReadOnlyGroupName(String ReadOnlyGroupName) {
        this.ReadOnlyGroupName = ReadOnlyGroupName;
    }

    /**
     * Get Region ID of the read-only group. 
     * @return RegionId Region ID of the read-only group.
     */
    public String getRegionId() {
        return this.RegionId;
    }

    /**
     * Set Region ID of the read-only group.
     * @param RegionId Region ID of the read-only group.
     */
    public void setRegionId(String RegionId) {
        this.RegionId = RegionId;
    }

    /**
     * Get AZ ID of the read-only group. 
     * @return ZoneId AZ ID of the read-only group.
     */
    public String getZoneId() {
        return this.ZoneId;
    }

    /**
     * Set AZ ID of the read-only group.
     * @param ZoneId AZ ID of the read-only group.
     */
    public void setZoneId(String ZoneId) {
        this.ZoneId = ZoneId;
    }

    /**
     * Get Whether to enable startup timeout elimination, 0 - disable removal, 1 - enable removal. 
     * @return IsOfflineDelay Whether to enable startup timeout elimination, 0 - disable removal, 1 - enable removal.
     */
    public Long getIsOfflineDelay() {
        return this.IsOfflineDelay;
    }

    /**
     * Set Whether to enable startup timeout elimination, 0 - disable removal, 1 - enable removal.
     * @param IsOfflineDelay Whether to enable startup timeout elimination, 0 - disable removal, 1 - enable removal.
     */
    public void setIsOfflineDelay(Long IsOfflineDelay) {
        this.IsOfflineDelay = IsOfflineDelay;
    }

    /**
     * Get Timeout threshold used after the delayed read-only instance removal feature is enabled, in seconds. 
     * @return ReadOnlyMaxDelayTime Timeout threshold used after the delayed read-only instance removal feature is enabled, in seconds.
     */
    public Long getReadOnlyMaxDelayTime() {
        return this.ReadOnlyMaxDelayTime;
    }

    /**
     * Set Timeout threshold used after the delayed read-only instance removal feature is enabled, in seconds.
     * @param ReadOnlyMaxDelayTime Timeout threshold used after the delayed read-only instance removal feature is enabled, in seconds.
     */
    public void setReadOnlyMaxDelayTime(Long ReadOnlyMaxDelayTime) {
        this.ReadOnlyMaxDelayTime = ReadOnlyMaxDelayTime;
    }

    /**
     * Get Minimum number of retained read-only replicas in the read-only group, after the delayed read-only instance removal feature is enabled. 
     * @return MinReadOnlyInGroup Minimum number of retained read-only replicas in the read-only group, after the delayed read-only instance removal feature is enabled.
     */
    public Long getMinReadOnlyInGroup() {
        return this.MinReadOnlyInGroup;
    }

    /**
     * Set Minimum number of retained read-only replicas in the read-only group, after the delayed read-only instance removal feature is enabled.
     * @param MinReadOnlyInGroup Minimum number of retained read-only replicas in the read-only group, after the delayed read-only instance removal feature is enabled.
     */
    public void setMinReadOnlyInGroup(Long MinReadOnlyInGroup) {
        this.MinReadOnlyInGroup = MinReadOnlyInGroup;
    }

    /**
     * Get Read-only group VIP. 
     * @return Vip Read-only group VIP.
     */
    public String getVip() {
        return this.Vip;
    }

    /**
     * Set Read-only group VIP.
     * @param Vip Read-only group VIP.
     */
    public void setVip(String Vip) {
        this.Vip = Vip;
    }

    /**
     * Get Read-only group VPort. 
     * @return Vport Read-only group VPort.
     */
    public Long getVport() {
        return this.Vport;
    }

    /**
     * Set Read-only group VPort.
     * @param Vport Read-only group VPort.
     */
    public void setVport(Long Vport) {
        this.Vport = Vport;
    }

    /**
     * Get VPC ID of the read-only group. 
     * @return VpcId VPC ID of the read-only group.
     */
    public String getVpcId() {
        return this.VpcId;
    }

    /**
     * Set VPC ID of the read-only group.
     * @param VpcId VPC ID of the read-only group.
     */
    public void setVpcId(String VpcId) {
        this.VpcId = VpcId;
    }

    /**
     * Get VPC subnet ID of the read-only group. 
     * @return SubnetId VPC subnet ID of the read-only group.
     */
    public String getSubnetId() {
        return this.SubnetId;
    }

    /**
     * Set VPC subnet ID of the read-only group.
     * @param SubnetId VPC subnet ID of the read-only group.
     */
    public void setSubnetId(String SubnetId) {
        this.SubnetId = SubnetId;
    }

    /**
     * Get Primary instance ID. For example, mssql-sgeshe3th. 
     * @return MasterInstanceId Primary instance ID. For example, mssql-sgeshe3th.
     */
    public String getMasterInstanceId() {
        return this.MasterInstanceId;
    }

    /**
     * Set Primary instance ID. For example, mssql-sgeshe3th.
     * @param MasterInstanceId Primary instance ID. For example, mssql-sgeshe3th.
     */
    public void setMasterInstanceId(String MasterInstanceId) {
        this.MasterInstanceId = MasterInstanceId;
    }

    /**
     * Get Region ID of the primary instance. 
     * @return MasterRegionId Region ID of the primary instance.
     */
    public String getMasterRegionId() {
        return this.MasterRegionId;
    }

    /**
     * Set Region ID of the primary instance.
     * @param MasterRegionId Region ID of the primary instance.
     */
    public void setMasterRegionId(String MasterRegionId) {
        this.MasterRegionId = MasterRegionId;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeReadOnlyGroupByReadOnlyInstanceResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeReadOnlyGroupByReadOnlyInstanceResponse(DescribeReadOnlyGroupByReadOnlyInstanceResponse source) {
        if (source.ReadOnlyGroupId != null) {
            this.ReadOnlyGroupId = new String(source.ReadOnlyGroupId);
        }
        if (source.ReadOnlyGroupName != null) {
            this.ReadOnlyGroupName = new String(source.ReadOnlyGroupName);
        }
        if (source.RegionId != null) {
            this.RegionId = new String(source.RegionId);
        }
        if (source.ZoneId != null) {
            this.ZoneId = new String(source.ZoneId);
        }
        if (source.IsOfflineDelay != null) {
            this.IsOfflineDelay = new Long(source.IsOfflineDelay);
        }
        if (source.ReadOnlyMaxDelayTime != null) {
            this.ReadOnlyMaxDelayTime = new Long(source.ReadOnlyMaxDelayTime);
        }
        if (source.MinReadOnlyInGroup != null) {
            this.MinReadOnlyInGroup = new Long(source.MinReadOnlyInGroup);
        }
        if (source.Vip != null) {
            this.Vip = new String(source.Vip);
        }
        if (source.Vport != null) {
            this.Vport = new Long(source.Vport);
        }
        if (source.VpcId != null) {
            this.VpcId = new String(source.VpcId);
        }
        if (source.SubnetId != null) {
            this.SubnetId = new String(source.SubnetId);
        }
        if (source.MasterInstanceId != null) {
            this.MasterInstanceId = new String(source.MasterInstanceId);
        }
        if (source.MasterRegionId != null) {
            this.MasterRegionId = new String(source.MasterRegionId);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ReadOnlyGroupId", this.ReadOnlyGroupId);
        this.setParamSimple(map, prefix + "ReadOnlyGroupName", this.ReadOnlyGroupName);
        this.setParamSimple(map, prefix + "RegionId", this.RegionId);
        this.setParamSimple(map, prefix + "ZoneId", this.ZoneId);
        this.setParamSimple(map, prefix + "IsOfflineDelay", this.IsOfflineDelay);
        this.setParamSimple(map, prefix + "ReadOnlyMaxDelayTime", this.ReadOnlyMaxDelayTime);
        this.setParamSimple(map, prefix + "MinReadOnlyInGroup", this.MinReadOnlyInGroup);
        this.setParamSimple(map, prefix + "Vip", this.Vip);
        this.setParamSimple(map, prefix + "Vport", this.Vport);
        this.setParamSimple(map, prefix + "VpcId", this.VpcId);
        this.setParamSimple(map, prefix + "SubnetId", this.SubnetId);
        this.setParamSimple(map, prefix + "MasterInstanceId", this.MasterInstanceId);
        this.setParamSimple(map, prefix + "MasterRegionId", this.MasterRegionId);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

