/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.sqlserver.v20180328.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeRegularBackupPlanResponse extends AbstractModel {

    /**
    * Regular backup plan.
    */
    @SerializedName("SaveModePeriod")
    @Expose
    private String [] SaveModePeriod;

    /**
    * Scheduled backup plan.
    */
    @SerializedName("SaveModeRegular")
    @Expose
    private String [] SaveModeRegular;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Regular backup plan. 
     * @return SaveModePeriod Regular backup plan.
     */
    public String [] getSaveModePeriod() {
        return this.SaveModePeriod;
    }

    /**
     * Set Regular backup plan.
     * @param SaveModePeriod Regular backup plan.
     */
    public void setSaveModePeriod(String [] SaveModePeriod) {
        this.SaveModePeriod = SaveModePeriod;
    }

    /**
     * Get Scheduled backup plan. 
     * @return SaveModeRegular Scheduled backup plan.
     */
    public String [] getSaveModeRegular() {
        return this.SaveModeRegular;
    }

    /**
     * Set Scheduled backup plan.
     * @param SaveModeRegular Scheduled backup plan.
     */
    public void setSaveModeRegular(String [] SaveModeRegular) {
        this.SaveModeRegular = SaveModeRegular;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeRegularBackupPlanResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeRegularBackupPlanResponse(DescribeRegularBackupPlanResponse source) {
        if (source.SaveModePeriod != null) {
            this.SaveModePeriod = new String[source.SaveModePeriod.length];
            for (int i = 0; i < source.SaveModePeriod.length; i++) {
                this.SaveModePeriod[i] = new String(source.SaveModePeriod[i]);
            }
        }
        if (source.SaveModeRegular != null) {
            this.SaveModeRegular = new String[source.SaveModeRegular.length];
            for (int i = 0; i < source.SaveModeRegular.length; i++) {
                this.SaveModeRegular[i] = new String(source.SaveModeRegular[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "SaveModePeriod.", this.SaveModePeriod);
        this.setParamArraySimple(map, prefix + "SaveModeRegular.", this.SaveModeRegular);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

