/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.sqlserver.v20180328.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeSlowlogsResponse extends AbstractModel {

    /**
    * Total number of queries
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Information list of slow query logs
    */
    @SerializedName("Slowlogs")
    @Expose
    private SlowlogInfo [] Slowlogs;

    /**
    * 
    */
    @SerializedName("SlowLogs")
    @Expose
    private SlowLog [] SlowLogs;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of queries 
     * @return TotalCount Total number of queries
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number of queries
     * @param TotalCount Total number of queries
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Information list of slow query logs 
     * @return Slowlogs Information list of slow query logs
     * @deprecated
     */
    @Deprecated
    public SlowlogInfo [] getSlowlogs() {
        return this.Slowlogs;
    }

    /**
     * Set Information list of slow query logs
     * @param Slowlogs Information list of slow query logs
     * @deprecated
     */
    @Deprecated
    public void setSlowlogs(SlowlogInfo [] Slowlogs) {
        this.Slowlogs = Slowlogs;
    }

    /**
     * Get  
     * @return SlowLogs 
     */
    public SlowLog [] getSlowLogs() {
        return this.SlowLogs;
    }

    /**
     * Set 
     * @param SlowLogs 
     */
    public void setSlowLogs(SlowLog [] SlowLogs) {
        this.SlowLogs = SlowLogs;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeSlowlogsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeSlowlogsResponse(DescribeSlowlogsResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.Slowlogs != null) {
            this.Slowlogs = new SlowlogInfo[source.Slowlogs.length];
            for (int i = 0; i < source.Slowlogs.length; i++) {
                this.Slowlogs[i] = new SlowlogInfo(source.Slowlogs[i]);
            }
        }
        if (source.SlowLogs != null) {
            this.SlowLogs = new SlowLog[source.SlowLogs.length];
            for (int i = 0; i < source.SlowLogs.length; i++) {
                this.SlowLogs[i] = new SlowLog(source.SlowLogs[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArrayObj(map, prefix + "Slowlogs.", this.Slowlogs);
        this.setParamArrayObj(map, prefix + "SlowLogs.", this.SlowLogs);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

