/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.sqlserver.v20180328.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeSpecSellStatusResponse extends AbstractModel {

    /**
    * Status set of specifications in different regions.
    */
    @SerializedName("DescribeSpecSellStatusSet")
    @Expose
    private SpecSellStatus [] DescribeSpecSellStatusSet;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Status set of specifications in different regions. 
     * @return DescribeSpecSellStatusSet Status set of specifications in different regions.
     */
    public SpecSellStatus [] getDescribeSpecSellStatusSet() {
        return this.DescribeSpecSellStatusSet;
    }

    /**
     * Set Status set of specifications in different regions.
     * @param DescribeSpecSellStatusSet Status set of specifications in different regions.
     */
    public void setDescribeSpecSellStatusSet(SpecSellStatus [] DescribeSpecSellStatusSet) {
        this.DescribeSpecSellStatusSet = DescribeSpecSellStatusSet;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeSpecSellStatusResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeSpecSellStatusResponse(DescribeSpecSellStatusResponse source) {
        if (source.DescribeSpecSellStatusSet != null) {
            this.DescribeSpecSellStatusSet = new SpecSellStatus[source.DescribeSpecSellStatusSet.length];
            for (int i = 0; i < source.DescribeSpecSellStatusSet.length; i++) {
                this.DescribeSpecSellStatusSet[i] = new SpecSellStatus(source.DescribeSpecSellStatusSet[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "DescribeSpecSellStatusSet.", this.DescribeSpecSellStatusSet);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

