/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.sqlserver.v20180328.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeUpgradeInstanceCheckResponse extends AbstractModel {

    /**
    * Whether the configuration adjustment has an impact on the instance. 0 - no; 1 - yes.
    */
    @SerializedName("IsAffect")
    @Expose
    private Long IsAffect;

    /**
    * Whether the configuration adjustment can be executed. 0 - no; 1 - yes.
    */
    @SerializedName("Passed")
    @Expose
    private Long Passed;

    /**
    * Whether the configuration adjustment is a downgrade or an upgrade. Down - downgrade; up - upgrade.
    */
    @SerializedName("ModifyMode")
    @Expose
    private String ModifyMode;

    /**
    * Check item list.
    */
    @SerializedName("CheckItems")
    @Expose
    private CheckItem [] CheckItems;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Whether the configuration adjustment has an impact on the instance. 0 - no; 1 - yes. 
     * @return IsAffect Whether the configuration adjustment has an impact on the instance. 0 - no; 1 - yes.
     */
    public Long getIsAffect() {
        return this.IsAffect;
    }

    /**
     * Set Whether the configuration adjustment has an impact on the instance. 0 - no; 1 - yes.
     * @param IsAffect Whether the configuration adjustment has an impact on the instance. 0 - no; 1 - yes.
     */
    public void setIsAffect(Long IsAffect) {
        this.IsAffect = IsAffect;
    }

    /**
     * Get Whether the configuration adjustment can be executed. 0 - no; 1 - yes. 
     * @return Passed Whether the configuration adjustment can be executed. 0 - no; 1 - yes.
     */
    public Long getPassed() {
        return this.Passed;
    }

    /**
     * Set Whether the configuration adjustment can be executed. 0 - no; 1 - yes.
     * @param Passed Whether the configuration adjustment can be executed. 0 - no; 1 - yes.
     */
    public void setPassed(Long Passed) {
        this.Passed = Passed;
    }

    /**
     * Get Whether the configuration adjustment is a downgrade or an upgrade. Down - downgrade; up - upgrade. 
     * @return ModifyMode Whether the configuration adjustment is a downgrade or an upgrade. Down - downgrade; up - upgrade.
     */
    public String getModifyMode() {
        return this.ModifyMode;
    }

    /**
     * Set Whether the configuration adjustment is a downgrade or an upgrade. Down - downgrade; up - upgrade.
     * @param ModifyMode Whether the configuration adjustment is a downgrade or an upgrade. Down - downgrade; up - upgrade.
     */
    public void setModifyMode(String ModifyMode) {
        this.ModifyMode = ModifyMode;
    }

    /**
     * Get Check item list. 
     * @return CheckItems Check item list.
     */
    public CheckItem [] getCheckItems() {
        return this.CheckItems;
    }

    /**
     * Set Check item list.
     * @param CheckItems Check item list.
     */
    public void setCheckItems(CheckItem [] CheckItems) {
        this.CheckItems = CheckItems;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeUpgradeInstanceCheckResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeUpgradeInstanceCheckResponse(DescribeUpgradeInstanceCheckResponse source) {
        if (source.IsAffect != null) {
            this.IsAffect = new Long(source.IsAffect);
        }
        if (source.Passed != null) {
            this.Passed = new Long(source.Passed);
        }
        if (source.ModifyMode != null) {
            this.ModifyMode = new String(source.ModifyMode);
        }
        if (source.CheckItems != null) {
            this.CheckItems = new CheckItem[source.CheckItems.length];
            for (int i = 0; i < source.CheckItems.length; i++) {
                this.CheckItems[i] = new CheckItem(source.CheckItems[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "IsAffect", this.IsAffect);
        this.setParamSimple(map, prefix + "Passed", this.Passed);
        this.setParamSimple(map, prefix + "ModifyMode", this.ModifyMode);
        this.setParamArrayObj(map, prefix + "CheckItems.", this.CheckItems);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

