/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.sqlserver.v20180328.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ModifyBackupStrategyResponse extends AbstractModel {

    /**
    * Returned error code.
    */
    @SerializedName("Errno")
    @Expose
    private Long Errno;

    /**
    * Returned error message.
    */
    @SerializedName("Msg")
    @Expose
    private String Msg;

    /**
    * Returned error code.
    */
    @SerializedName("Code")
    @Expose
    private Long Code;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Returned error code. 
     * @return Errno Returned error code.
     * @deprecated
     */
    @Deprecated
    public Long getErrno() {
        return this.Errno;
    }

    /**
     * Set Returned error code.
     * @param Errno Returned error code.
     * @deprecated
     */
    @Deprecated
    public void setErrno(Long Errno) {
        this.Errno = Errno;
    }

    /**
     * Get Returned error message. 
     * @return Msg Returned error message.
     */
    public String getMsg() {
        return this.Msg;
    }

    /**
     * Set Returned error message.
     * @param Msg Returned error message.
     */
    public void setMsg(String Msg) {
        this.Msg = Msg;
    }

    /**
     * Get Returned error code. 
     * @return Code Returned error code.
     */
    public Long getCode() {
        return this.Code;
    }

    /**
     * Set Returned error code.
     * @param Code Returned error code.
     */
    public void setCode(Long Code) {
        this.Code = Code;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public ModifyBackupStrategyResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ModifyBackupStrategyResponse(ModifyBackupStrategyResponse source) {
        if (source.Errno != null) {
            this.Errno = new Long(source.Errno);
        }
        if (source.Msg != null) {
            this.Msg = new String(source.Msg);
        }
        if (source.Code != null) {
            this.Code = new Long(source.Code);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Errno", this.Errno);
        this.setParamSimple(map, prefix + "Msg", this.Msg);
        this.setParamSimple(map, prefix + "Code", this.Code);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

