/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.sqlserver.v20180328.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class QueryMigrationCheckProcessResponse extends AbstractModel {

    /**
    * Total number of steps.
    */
    @SerializedName("TotalStep")
    @Expose
    private Long TotalStep;

    /**
    * Current step number, starting from 1.
    */
    @SerializedName("CurrentStep")
    @Expose
    private Long CurrentStep;

    /**
    * Details of all steps.
    */
    @SerializedName("StepDetails")
    @Expose
    private StepDetail [] StepDetails;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of steps. 
     * @return TotalStep Total number of steps.
     */
    public Long getTotalStep() {
        return this.TotalStep;
    }

    /**
     * Set Total number of steps.
     * @param TotalStep Total number of steps.
     */
    public void setTotalStep(Long TotalStep) {
        this.TotalStep = TotalStep;
    }

    /**
     * Get Current step number, starting from 1. 
     * @return CurrentStep Current step number, starting from 1.
     */
    public Long getCurrentStep() {
        return this.CurrentStep;
    }

    /**
     * Set Current step number, starting from 1.
     * @param CurrentStep Current step number, starting from 1.
     */
    public void setCurrentStep(Long CurrentStep) {
        this.CurrentStep = CurrentStep;
    }

    /**
     * Get Details of all steps. 
     * @return StepDetails Details of all steps.
     */
    public StepDetail [] getStepDetails() {
        return this.StepDetails;
    }

    /**
     * Set Details of all steps.
     * @param StepDetails Details of all steps.
     */
    public void setStepDetails(StepDetail [] StepDetails) {
        this.StepDetails = StepDetails;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public QueryMigrationCheckProcessResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public QueryMigrationCheckProcessResponse(QueryMigrationCheckProcessResponse source) {
        if (source.TotalStep != null) {
            this.TotalStep = new Long(source.TotalStep);
        }
        if (source.CurrentStep != null) {
            this.CurrentStep = new Long(source.CurrentStep);
        }
        if (source.StepDetails != null) {
            this.StepDetails = new StepDetail[source.StepDetails.length];
            for (int i = 0; i < source.StepDetails.length; i++) {
                this.StepDetails[i] = new StepDetail(source.StepDetails[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalStep", this.TotalStep);
        this.setParamSimple(map, prefix + "CurrentStep", this.CurrentStep);
        this.setParamArrayObj(map, prefix + "StepDetails.", this.StepDetails);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

