/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ssl.v20191205.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DdosInstanceDetail extends AbstractModel {

    /**
    * The domain.
    */
    @SerializedName("Domain")
    @Expose
    private String Domain;

    /**
    * The instance ID.
    */
    @SerializedName("InstanceId")
    @Expose
    private String InstanceId;

    /**
    * The protocol type.
    */
    @SerializedName("Protocol")
    @Expose
    private String Protocol;

    /**
    * Certificate id.
    */
    @SerializedName("CertId")
    @Expose
    private String CertId;

    /**
    * The forwarding port.
    */
    @SerializedName("VirtualPort")
    @Expose
    private String VirtualPort;

    /**
     * Get The domain. 
     * @return Domain The domain.
     */
    public String getDomain() {
        return this.Domain;
    }

    /**
     * Set The domain.
     * @param Domain The domain.
     */
    public void setDomain(String Domain) {
        this.Domain = Domain;
    }

    /**
     * Get The instance ID. 
     * @return InstanceId The instance ID.
     */
    public String getInstanceId() {
        return this.InstanceId;
    }

    /**
     * Set The instance ID.
     * @param InstanceId The instance ID.
     */
    public void setInstanceId(String InstanceId) {
        this.InstanceId = InstanceId;
    }

    /**
     * Get The protocol type. 
     * @return Protocol The protocol type.
     */
    public String getProtocol() {
        return this.Protocol;
    }

    /**
     * Set The protocol type.
     * @param Protocol The protocol type.
     */
    public void setProtocol(String Protocol) {
        this.Protocol = Protocol;
    }

    /**
     * Get Certificate id. 
     * @return CertId Certificate id.
     */
    public String getCertId() {
        return this.CertId;
    }

    /**
     * Set Certificate id.
     * @param CertId Certificate id.
     */
    public void setCertId(String CertId) {
        this.CertId = CertId;
    }

    /**
     * Get The forwarding port. 
     * @return VirtualPort The forwarding port.
     */
    public String getVirtualPort() {
        return this.VirtualPort;
    }

    /**
     * Set The forwarding port.
     * @param VirtualPort The forwarding port.
     */
    public void setVirtualPort(String VirtualPort) {
        this.VirtualPort = VirtualPort;
    }

    public DdosInstanceDetail() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DdosInstanceDetail(DdosInstanceDetail source) {
        if (source.Domain != null) {
            this.Domain = new String(source.Domain);
        }
        if (source.InstanceId != null) {
            this.InstanceId = new String(source.InstanceId);
        }
        if (source.Protocol != null) {
            this.Protocol = new String(source.Protocol);
        }
        if (source.CertId != null) {
            this.CertId = new String(source.CertId);
        }
        if (source.VirtualPort != null) {
            this.VirtualPort = new String(source.VirtualPort);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Domain", this.Domain);
        this.setParamSimple(map, prefix + "InstanceId", this.InstanceId);
        this.setParamSimple(map, prefix + "Protocol", this.Protocol);
        this.setParamSimple(map, prefix + "CertId", this.CertId);
        this.setParamSimple(map, prefix + "VirtualPort", this.VirtualPort);

    }
}

