/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ssm.v20190923.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GetServiceStatusResponse extends AbstractModel {

    /**
    * `true`: The service is activated; `false`: The service is not activated.
    */
    @SerializedName("ServiceEnabled")
    @Expose
    private Boolean ServiceEnabled;

    /**
    * Invalid service type. `0`: not purchased; `1`: normal; `2`: suspended due to arrears; `3`: resource released
    */
    @SerializedName("InvalidType")
    @Expose
    private Long InvalidType;

    /**
    * `true`: Allow SSM to manage Tencent Cloud API key secrets.
`false`: Forbid SSM to manage Tencent Cloud API key secrets.
    */
    @SerializedName("AccessKeyEscrowEnabled")
    @Expose
    private Boolean AccessKeyEscrowEnabled;

    /**
    * The unique request ID, which is returned for each request. RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get `true`: The service is activated; `false`: The service is not activated. 
     * @return ServiceEnabled `true`: The service is activated; `false`: The service is not activated.
     */
    public Boolean getServiceEnabled() {
        return this.ServiceEnabled;
    }

    /**
     * Set `true`: The service is activated; `false`: The service is not activated.
     * @param ServiceEnabled `true`: The service is activated; `false`: The service is not activated.
     */
    public void setServiceEnabled(Boolean ServiceEnabled) {
        this.ServiceEnabled = ServiceEnabled;
    }

    /**
     * Get Invalid service type. `0`: not purchased; `1`: normal; `2`: suspended due to arrears; `3`: resource released 
     * @return InvalidType Invalid service type. `0`: not purchased; `1`: normal; `2`: suspended due to arrears; `3`: resource released
     */
    public Long getInvalidType() {
        return this.InvalidType;
    }

    /**
     * Set Invalid service type. `0`: not purchased; `1`: normal; `2`: suspended due to arrears; `3`: resource released
     * @param InvalidType Invalid service type. `0`: not purchased; `1`: normal; `2`: suspended due to arrears; `3`: resource released
     */
    public void setInvalidType(Long InvalidType) {
        this.InvalidType = InvalidType;
    }

    /**
     * Get `true`: Allow SSM to manage Tencent Cloud API key secrets.
`false`: Forbid SSM to manage Tencent Cloud API key secrets. 
     * @return AccessKeyEscrowEnabled `true`: Allow SSM to manage Tencent Cloud API key secrets.
`false`: Forbid SSM to manage Tencent Cloud API key secrets.
     */
    public Boolean getAccessKeyEscrowEnabled() {
        return this.AccessKeyEscrowEnabled;
    }

    /**
     * Set `true`: Allow SSM to manage Tencent Cloud API key secrets.
`false`: Forbid SSM to manage Tencent Cloud API key secrets.
     * @param AccessKeyEscrowEnabled `true`: Allow SSM to manage Tencent Cloud API key secrets.
`false`: Forbid SSM to manage Tencent Cloud API key secrets.
     */
    public void setAccessKeyEscrowEnabled(Boolean AccessKeyEscrowEnabled) {
        this.AccessKeyEscrowEnabled = AccessKeyEscrowEnabled;
    }

    /**
     * Get The unique request ID, which is returned for each request. RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     * @param RequestId The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public GetServiceStatusResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GetServiceStatusResponse(GetServiceStatusResponse source) {
        if (source.ServiceEnabled != null) {
            this.ServiceEnabled = new Boolean(source.ServiceEnabled);
        }
        if (source.InvalidType != null) {
            this.InvalidType = new Long(source.InvalidType);
        }
        if (source.AccessKeyEscrowEnabled != null) {
            this.AccessKeyEscrowEnabled = new Boolean(source.AccessKeyEscrowEnabled);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ServiceEnabled", this.ServiceEnabled);
        this.setParamSimple(map, prefix + "InvalidType", this.InvalidType);
        this.setParamSimple(map, prefix + "AccessKeyEscrowEnabled", this.AccessKeyEscrowEnabled);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

