/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ssm.v20190923.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ListSecretsResponse extends AbstractModel {

    /**
    * Number of filtered Secrets according to `State` and `SearchSecretName`.
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * List of Secret information.
    */
    @SerializedName("SecretMetadatas")
    @Expose
    private SecretMetadata [] SecretMetadatas;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Number of filtered Secrets according to `State` and `SearchSecretName`. 
     * @return TotalCount Number of filtered Secrets according to `State` and `SearchSecretName`.
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Number of filtered Secrets according to `State` and `SearchSecretName`.
     * @param TotalCount Number of filtered Secrets according to `State` and `SearchSecretName`.
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get List of Secret information. 
     * @return SecretMetadatas List of Secret information.
     */
    public SecretMetadata [] getSecretMetadatas() {
        return this.SecretMetadatas;
    }

    /**
     * Set List of Secret information.
     * @param SecretMetadatas List of Secret information.
     */
    public void setSecretMetadatas(SecretMetadata [] SecretMetadatas) {
        this.SecretMetadatas = SecretMetadatas;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public ListSecretsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ListSecretsResponse(ListSecretsResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.SecretMetadatas != null) {
            this.SecretMetadatas = new SecretMetadata[source.SecretMetadatas.length];
            for (int i = 0; i < source.SecretMetadatas.length; i++) {
                this.SecretMetadatas[i] = new SecretMetadata(source.SecretMetadatas[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArrayObj(map, prefix + "SecretMetadatas.", this.SecretMetadatas);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

