/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tbaas.v20180416.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeFabricBlockResponse extends AbstractModel {

    /**
    * Block height.
    */
    @SerializedName("BlockHeight")
    @Expose
    private Long BlockHeight;

    /**
    * Block Hash.
    */
    @SerializedName("BlockHash")
    @Expose
    private String BlockHash;

    /**
    * Pre-Block Hash.
    */
    @SerializedName("PreBlockHash")
    @Expose
    private String PreBlockHash;

    /**
    * The number of transactions in a block.
    */
    @SerializedName("TxCount")
    @Expose
    private Long TxCount;

    /**
    * Transaction list in the block.
    */
    @SerializedName("TransactionList")
    @Expose
    private Transaction [] TransactionList;

    /**
    * Creation Timestamp
    */
    @SerializedName("CreateTimestamp")
    @Expose
    private String CreateTimestamp;

    /**
    * Proposal organization.
    */
    @SerializedName("ProposerOrg")
    @Expose
    private String ProposerOrg;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Block height. 
     * @return BlockHeight Block height.
     */
    public Long getBlockHeight() {
        return this.BlockHeight;
    }

    /**
     * Set Block height.
     * @param BlockHeight Block height.
     */
    public void setBlockHeight(Long BlockHeight) {
        this.BlockHeight = BlockHeight;
    }

    /**
     * Get Block Hash. 
     * @return BlockHash Block Hash.
     */
    public String getBlockHash() {
        return this.BlockHash;
    }

    /**
     * Set Block Hash.
     * @param BlockHash Block Hash.
     */
    public void setBlockHash(String BlockHash) {
        this.BlockHash = BlockHash;
    }

    /**
     * Get Pre-Block Hash. 
     * @return PreBlockHash Pre-Block Hash.
     */
    public String getPreBlockHash() {
        return this.PreBlockHash;
    }

    /**
     * Set Pre-Block Hash.
     * @param PreBlockHash Pre-Block Hash.
     */
    public void setPreBlockHash(String PreBlockHash) {
        this.PreBlockHash = PreBlockHash;
    }

    /**
     * Get The number of transactions in a block. 
     * @return TxCount The number of transactions in a block.
     */
    public Long getTxCount() {
        return this.TxCount;
    }

    /**
     * Set The number of transactions in a block.
     * @param TxCount The number of transactions in a block.
     */
    public void setTxCount(Long TxCount) {
        this.TxCount = TxCount;
    }

    /**
     * Get Transaction list in the block. 
     * @return TransactionList Transaction list in the block.
     */
    public Transaction [] getTransactionList() {
        return this.TransactionList;
    }

    /**
     * Set Transaction list in the block.
     * @param TransactionList Transaction list in the block.
     */
    public void setTransactionList(Transaction [] TransactionList) {
        this.TransactionList = TransactionList;
    }

    /**
     * Get Creation Timestamp 
     * @return CreateTimestamp Creation Timestamp
     */
    public String getCreateTimestamp() {
        return this.CreateTimestamp;
    }

    /**
     * Set Creation Timestamp
     * @param CreateTimestamp Creation Timestamp
     */
    public void setCreateTimestamp(String CreateTimestamp) {
        this.CreateTimestamp = CreateTimestamp;
    }

    /**
     * Get Proposal organization. 
     * @return ProposerOrg Proposal organization.
     */
    public String getProposerOrg() {
        return this.ProposerOrg;
    }

    /**
     * Set Proposal organization.
     * @param ProposerOrg Proposal organization.
     */
    public void setProposerOrg(String ProposerOrg) {
        this.ProposerOrg = ProposerOrg;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeFabricBlockResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeFabricBlockResponse(DescribeFabricBlockResponse source) {
        if (source.BlockHeight != null) {
            this.BlockHeight = new Long(source.BlockHeight);
        }
        if (source.BlockHash != null) {
            this.BlockHash = new String(source.BlockHash);
        }
        if (source.PreBlockHash != null) {
            this.PreBlockHash = new String(source.PreBlockHash);
        }
        if (source.TxCount != null) {
            this.TxCount = new Long(source.TxCount);
        }
        if (source.TransactionList != null) {
            this.TransactionList = new Transaction[source.TransactionList.length];
            for (int i = 0; i < source.TransactionList.length; i++) {
                this.TransactionList[i] = new Transaction(source.TransactionList[i]);
            }
        }
        if (source.CreateTimestamp != null) {
            this.CreateTimestamp = new String(source.CreateTimestamp);
        }
        if (source.ProposerOrg != null) {
            this.ProposerOrg = new String(source.ProposerOrg);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "BlockHeight", this.BlockHeight);
        this.setParamSimple(map, prefix + "BlockHash", this.BlockHash);
        this.setParamSimple(map, prefix + "PreBlockHash", this.PreBlockHash);
        this.setParamSimple(map, prefix + "TxCount", this.TxCount);
        this.setParamArrayObj(map, prefix + "TransactionList.", this.TransactionList);
        this.setParamSimple(map, prefix + "CreateTimestamp", this.CreateTimestamp);
        this.setParamSimple(map, prefix + "ProposerOrg", this.ProposerOrg);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

