/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tbaas.v20180416.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeFabricTransactionResponse extends AbstractModel {

    /**
    * Transaction ID
    */
    @SerializedName("TxId")
    @Expose
    private String TxId;

    /**
    * Transaction Hash.
    */
    @SerializedName("TxHash")
    @Expose
    private String TxHash;

    /**
    * Transaction status.
    */
    @SerializedName("TxStatus")
    @Expose
    private String TxStatus;

    /**
    * Organization list involved.
    */
    @SerializedName("JoinOrgList")
    @Expose
    private String [] JoinOrgList;

    /**
    * Transaction sender.
    */
    @SerializedName("Sender")
    @Expose
    private String Sender;

    /**
    * Creation time
    */
    @SerializedName("CreateTime")
    @Expose
    private String CreateTime;

    /**
    * Block height.
    */
    @SerializedName("BlockHeight")
    @Expose
    private Long BlockHeight;

    /**
    * The contract to which the exchange belongs.
    */
    @SerializedName("ChaincodeName")
    @Expose
    private String ChaincodeName;

    /**
    * Transaction data, base64 encoded, decoded as a json string.
    */
    @SerializedName("TransactionData")
    @Expose
    private String TransactionData;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Transaction ID 
     * @return TxId Transaction ID
     */
    public String getTxId() {
        return this.TxId;
    }

    /**
     * Set Transaction ID
     * @param TxId Transaction ID
     */
    public void setTxId(String TxId) {
        this.TxId = TxId;
    }

    /**
     * Get Transaction Hash. 
     * @return TxHash Transaction Hash.
     */
    public String getTxHash() {
        return this.TxHash;
    }

    /**
     * Set Transaction Hash.
     * @param TxHash Transaction Hash.
     */
    public void setTxHash(String TxHash) {
        this.TxHash = TxHash;
    }

    /**
     * Get Transaction status. 
     * @return TxStatus Transaction status.
     */
    public String getTxStatus() {
        return this.TxStatus;
    }

    /**
     * Set Transaction status.
     * @param TxStatus Transaction status.
     */
    public void setTxStatus(String TxStatus) {
        this.TxStatus = TxStatus;
    }

    /**
     * Get Organization list involved. 
     * @return JoinOrgList Organization list involved.
     */
    public String [] getJoinOrgList() {
        return this.JoinOrgList;
    }

    /**
     * Set Organization list involved.
     * @param JoinOrgList Organization list involved.
     */
    public void setJoinOrgList(String [] JoinOrgList) {
        this.JoinOrgList = JoinOrgList;
    }

    /**
     * Get Transaction sender. 
     * @return Sender Transaction sender.
     */
    public String getSender() {
        return this.Sender;
    }

    /**
     * Set Transaction sender.
     * @param Sender Transaction sender.
     */
    public void setSender(String Sender) {
        this.Sender = Sender;
    }

    /**
     * Get Creation time 
     * @return CreateTime Creation time
     */
    public String getCreateTime() {
        return this.CreateTime;
    }

    /**
     * Set Creation time
     * @param CreateTime Creation time
     */
    public void setCreateTime(String CreateTime) {
        this.CreateTime = CreateTime;
    }

    /**
     * Get Block height. 
     * @return BlockHeight Block height.
     */
    public Long getBlockHeight() {
        return this.BlockHeight;
    }

    /**
     * Set Block height.
     * @param BlockHeight Block height.
     */
    public void setBlockHeight(Long BlockHeight) {
        this.BlockHeight = BlockHeight;
    }

    /**
     * Get The contract to which the exchange belongs. 
     * @return ChaincodeName The contract to which the exchange belongs.
     */
    public String getChaincodeName() {
        return this.ChaincodeName;
    }

    /**
     * Set The contract to which the exchange belongs.
     * @param ChaincodeName The contract to which the exchange belongs.
     */
    public void setChaincodeName(String ChaincodeName) {
        this.ChaincodeName = ChaincodeName;
    }

    /**
     * Get Transaction data, base64 encoded, decoded as a json string. 
     * @return TransactionData Transaction data, base64 encoded, decoded as a json string.
     */
    public String getTransactionData() {
        return this.TransactionData;
    }

    /**
     * Set Transaction data, base64 encoded, decoded as a json string.
     * @param TransactionData Transaction data, base64 encoded, decoded as a json string.
     */
    public void setTransactionData(String TransactionData) {
        this.TransactionData = TransactionData;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeFabricTransactionResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeFabricTransactionResponse(DescribeFabricTransactionResponse source) {
        if (source.TxId != null) {
            this.TxId = new String(source.TxId);
        }
        if (source.TxHash != null) {
            this.TxHash = new String(source.TxHash);
        }
        if (source.TxStatus != null) {
            this.TxStatus = new String(source.TxStatus);
        }
        if (source.JoinOrgList != null) {
            this.JoinOrgList = new String[source.JoinOrgList.length];
            for (int i = 0; i < source.JoinOrgList.length; i++) {
                this.JoinOrgList[i] = new String(source.JoinOrgList[i]);
            }
        }
        if (source.Sender != null) {
            this.Sender = new String(source.Sender);
        }
        if (source.CreateTime != null) {
            this.CreateTime = new String(source.CreateTime);
        }
        if (source.BlockHeight != null) {
            this.BlockHeight = new Long(source.BlockHeight);
        }
        if (source.ChaincodeName != null) {
            this.ChaincodeName = new String(source.ChaincodeName);
        }
        if (source.TransactionData != null) {
            this.TransactionData = new String(source.TransactionData);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TxId", this.TxId);
        this.setParamSimple(map, prefix + "TxHash", this.TxHash);
        this.setParamSimple(map, prefix + "TxStatus", this.TxStatus);
        this.setParamArraySimple(map, prefix + "JoinOrgList.", this.JoinOrgList);
        this.setParamSimple(map, prefix + "Sender", this.Sender);
        this.setParamSimple(map, prefix + "CreateTime", this.CreateTime);
        this.setParamSimple(map, prefix + "BlockHeight", this.BlockHeight);
        this.setParamSimple(map, prefix + "ChaincodeName", this.ChaincodeName);
        this.setParamSimple(map, prefix + "TransactionData", this.TransactionData);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

