/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tbaas.v20180416.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class InvokeFabricChaincodeResponse extends AbstractModel {

    /**
    * Transaction ID
    */
    @SerializedName("TxId")
    @Expose
    private String TxId;

    /**
    * Transaction status.
    */
    @SerializedName("TxStatus")
    @Expose
    private String TxStatus;

    /**
    * Transaction result.
    */
    @SerializedName("TxResult")
    @Expose
    private String TxResult;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Transaction ID 
     * @return TxId Transaction ID
     */
    public String getTxId() {
        return this.TxId;
    }

    /**
     * Set Transaction ID
     * @param TxId Transaction ID
     */
    public void setTxId(String TxId) {
        this.TxId = TxId;
    }

    /**
     * Get Transaction status. 
     * @return TxStatus Transaction status.
     */
    public String getTxStatus() {
        return this.TxStatus;
    }

    /**
     * Set Transaction status.
     * @param TxStatus Transaction status.
     */
    public void setTxStatus(String TxStatus) {
        this.TxStatus = TxStatus;
    }

    /**
     * Get Transaction result. 
     * @return TxResult Transaction result.
     */
    public String getTxResult() {
        return this.TxResult;
    }

    /**
     * Set Transaction result.
     * @param TxResult Transaction result.
     */
    public void setTxResult(String TxResult) {
        this.TxResult = TxResult;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public InvokeFabricChaincodeResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public InvokeFabricChaincodeResponse(InvokeFabricChaincodeResponse source) {
        if (source.TxId != null) {
            this.TxId = new String(source.TxId);
        }
        if (source.TxStatus != null) {
            this.TxStatus = new String(source.TxStatus);
        }
        if (source.TxResult != null) {
            this.TxResult = new String(source.TxResult);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TxId", this.TxId);
        this.setParamSimple(map, prefix + "TxStatus", this.TxStatus);
        this.setParamSimple(map, prefix + "TxResult", this.TxResult);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

