/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tcr.v20190924.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class Filter extends AbstractModel {

    /**
    * Attribute name. If more than one filter exists, the logical relationship between these filters is `AND`.
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
    * Attribute value. If multiple values exist in one filter, the logical relationship between these values is `OR`.
    */
    @SerializedName("Values")
    @Expose
    private String [] Values;

    /**
     * Get Attribute name. If more than one filter exists, the logical relationship between these filters is `AND`. 
     * @return Name Attribute name. If more than one filter exists, the logical relationship between these filters is `AND`.
     */
    public String getName() {
        return this.Name;
    }

    /**
     * Set Attribute name. If more than one filter exists, the logical relationship between these filters is `AND`.
     * @param Name Attribute name. If more than one filter exists, the logical relationship between these filters is `AND`.
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    /**
     * Get Attribute value. If multiple values exist in one filter, the logical relationship between these values is `OR`. 
     * @return Values Attribute value. If multiple values exist in one filter, the logical relationship between these values is `OR`.
     */
    public String [] getValues() {
        return this.Values;
    }

    /**
     * Set Attribute value. If multiple values exist in one filter, the logical relationship between these values is `OR`.
     * @param Values Attribute value. If multiple values exist in one filter, the logical relationship between these values is `OR`.
     */
    public void setValues(String [] Values) {
        this.Values = Values;
    }

    public Filter() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public Filter(Filter source) {
        if (source.Name != null) {
            this.Name = new String(source.Name);
        }
        if (source.Values != null) {
            this.Values = new String[source.Values.length];
            for (int i = 0; i < source.Values.length; i++) {
                this.Values[i] = new String(source.Values[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Name", this.Name);
        this.setParamArraySimple(map, prefix + "Values.", this.Values);

    }
}

