/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tcss.v20201101.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreateOrModifyPostPayCoresRequest extends AbstractModel {

    /**
    * Upper limit for elastic billing. Minimum value: `500`.
    */
    @SerializedName("CoresCnt")
    @Expose
    private Long CoresCnt;

    /**
     * Get Upper limit for elastic billing. Minimum value: `500`. 
     * @return CoresCnt Upper limit for elastic billing. Minimum value: `500`.
     */
    public Long getCoresCnt() {
        return this.CoresCnt;
    }

    /**
     * Set Upper limit for elastic billing. Minimum value: `500`.
     * @param CoresCnt Upper limit for elastic billing. Minimum value: `500`.
     */
    public void setCoresCnt(Long CoresCnt) {
        this.CoresCnt = CoresCnt;
    }

    public CreateOrModifyPostPayCoresRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreateOrModifyPostPayCoresRequest(CreateOrModifyPostPayCoresRequest source) {
        if (source.CoresCnt != null) {
            this.CoresCnt = new Long(source.CoresCnt);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "CoresCnt", this.CoresCnt);

    }
}

