/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tcss.v20201101.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeK8sApiAbnormalTendencyRequest extends AbstractModel {

    /**
    * Trend period (default value: 7 days)
    */
    @SerializedName("TendencyPeriod")
    @Expose
    private Long TendencyPeriod;

    /**
     * Get Trend period (default value: 7 days) 
     * @return TendencyPeriod Trend period (default value: 7 days)
     */
    public Long getTendencyPeriod() {
        return this.TendencyPeriod;
    }

    /**
     * Set Trend period (default value: 7 days)
     * @param TendencyPeriod Trend period (default value: 7 days)
     */
    public void setTendencyPeriod(Long TendencyPeriod) {
        this.TendencyPeriod = TendencyPeriod;
    }

    public DescribeK8sApiAbnormalTendencyRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeK8sApiAbnormalTendencyRequest(DescribeK8sApiAbnormalTendencyRequest source) {
        if (source.TendencyPeriod != null) {
            this.TendencyPeriod = new Long(source.TendencyPeriod);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TendencyPeriod", this.TendencyPeriod);

    }
}

