/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.teo.v20220901.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreateMultiPathGatewaySecretKeyRequest extends AbstractModel {

    /**
    * Zone ID.
    */
    @SerializedName("ZoneId")
    @Expose
    private String ZoneId;

    /**
    * Multi-Channel security acceleration gateway access key, base64 string, value range:length of the unencoded string: 32-48 characters, optional, automatically generated by the system if left blank, can be queried through the API DescribeMultiPathGatewaySecretKey.
    */
    @SerializedName("SecretKey")
    @Expose
    private String SecretKey;

    /**
     * Get Zone ID. 
     * @return ZoneId Zone ID.
     */
    public String getZoneId() {
        return this.ZoneId;
    }

    /**
     * Set Zone ID.
     * @param ZoneId Zone ID.
     */
    public void setZoneId(String ZoneId) {
        this.ZoneId = ZoneId;
    }

    /**
     * Get Multi-Channel security acceleration gateway access key, base64 string, value range:length of the unencoded string: 32-48 characters, optional, automatically generated by the system if left blank, can be queried through the API DescribeMultiPathGatewaySecretKey. 
     * @return SecretKey Multi-Channel security acceleration gateway access key, base64 string, value range:length of the unencoded string: 32-48 characters, optional, automatically generated by the system if left blank, can be queried through the API DescribeMultiPathGatewaySecretKey.
     */
    public String getSecretKey() {
        return this.SecretKey;
    }

    /**
     * Set Multi-Channel security acceleration gateway access key, base64 string, value range:length of the unencoded string: 32-48 characters, optional, automatically generated by the system if left blank, can be queried through the API DescribeMultiPathGatewaySecretKey.
     * @param SecretKey Multi-Channel security acceleration gateway access key, base64 string, value range:length of the unencoded string: 32-48 characters, optional, automatically generated by the system if left blank, can be queried through the API DescribeMultiPathGatewaySecretKey.
     */
    public void setSecretKey(String SecretKey) {
        this.SecretKey = SecretKey;
    }

    public CreateMultiPathGatewaySecretKeyRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreateMultiPathGatewaySecretKeyRequest(CreateMultiPathGatewaySecretKeyRequest source) {
        if (source.ZoneId != null) {
            this.ZoneId = new String(source.ZoneId);
        }
        if (source.SecretKey != null) {
            this.SecretKey = new String(source.SecretKey);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ZoneId", this.ZoneId);
        this.setParamSimple(map, prefix + "SecretKey", this.SecretKey);

    }
}

