/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.teo.v20220901.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeCustomErrorPagesResponse extends AbstractModel {

    /**
    * Total number of custom error pages.
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Custom error page data list.
    */
    @SerializedName("ErrorPages")
    @Expose
    private CustomErrorPage [] ErrorPages;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of custom error pages. 
     * @return TotalCount Total number of custom error pages.
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number of custom error pages.
     * @param TotalCount Total number of custom error pages.
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Custom error page data list. 
     * @return ErrorPages Custom error page data list.
     */
    public CustomErrorPage [] getErrorPages() {
        return this.ErrorPages;
    }

    /**
     * Set Custom error page data list.
     * @param ErrorPages Custom error page data list.
     */
    public void setErrorPages(CustomErrorPage [] ErrorPages) {
        this.ErrorPages = ErrorPages;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeCustomErrorPagesResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeCustomErrorPagesResponse(DescribeCustomErrorPagesResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.ErrorPages != null) {
            this.ErrorPages = new CustomErrorPage[source.ErrorPages.length];
            for (int i = 0; i < source.ErrorPages.length; i++) {
                this.ErrorPages[i] = new CustomErrorPage(source.ErrorPages[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArrayObj(map, prefix + "ErrorPages.", this.ErrorPages);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

