/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.teo.v20220901.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeMultiPathGatewayRegionsResponse extends AbstractModel {

    /**
    * Lists available regions for the gateway.
    */
    @SerializedName("GatewayRegions")
    @Expose
    private GatewayRegion [] GatewayRegions;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Lists available regions for the gateway. 
     * @return GatewayRegions Lists available regions for the gateway.
     */
    public GatewayRegion [] getGatewayRegions() {
        return this.GatewayRegions;
    }

    /**
     * Set Lists available regions for the gateway.
     * @param GatewayRegions Lists available regions for the gateway.
     */
    public void setGatewayRegions(GatewayRegion [] GatewayRegions) {
        this.GatewayRegions = GatewayRegions;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeMultiPathGatewayRegionsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeMultiPathGatewayRegionsResponse(DescribeMultiPathGatewayRegionsResponse source) {
        if (source.GatewayRegions != null) {
            this.GatewayRegions = new GatewayRegion[source.GatewayRegions.length];
            for (int i = 0; i < source.GatewayRegions.length; i++) {
                this.GatewayRegions[i] = new GatewayRegion(source.GatewayRegions[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "GatewayRegions.", this.GatewayRegions);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

