/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.teo.v20220901.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeSecurityIPGroupContentResponse extends AbstractModel {

    /**
    * Specifies the number of effective ips or IP ranges in the IP group.
    */
    @SerializedName("IPTotalCount")
    @Expose
    private Long IPTotalCount;

    /**
    * List of ips or ranges that meet the query conditions. limited by the Offset and Limit parameters.
    */
    @SerializedName("IPList")
    @Expose
    private String [] IPList;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Specifies the number of effective ips or IP ranges in the IP group. 
     * @return IPTotalCount Specifies the number of effective ips or IP ranges in the IP group.
     */
    public Long getIPTotalCount() {
        return this.IPTotalCount;
    }

    /**
     * Set Specifies the number of effective ips or IP ranges in the IP group.
     * @param IPTotalCount Specifies the number of effective ips or IP ranges in the IP group.
     */
    public void setIPTotalCount(Long IPTotalCount) {
        this.IPTotalCount = IPTotalCount;
    }

    /**
     * Get List of ips or ranges that meet the query conditions. limited by the Offset and Limit parameters. 
     * @return IPList List of ips or ranges that meet the query conditions. limited by the Offset and Limit parameters.
     */
    public String [] getIPList() {
        return this.IPList;
    }

    /**
     * Set List of ips or ranges that meet the query conditions. limited by the Offset and Limit parameters.
     * @param IPList List of ips or ranges that meet the query conditions. limited by the Offset and Limit parameters.
     */
    public void setIPList(String [] IPList) {
        this.IPList = IPList;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeSecurityIPGroupContentResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeSecurityIPGroupContentResponse(DescribeSecurityIPGroupContentResponse source) {
        if (source.IPTotalCount != null) {
            this.IPTotalCount = new Long(source.IPTotalCount);
        }
        if (source.IPList != null) {
            this.IPList = new String[source.IPList.length];
            for (int i = 0; i < source.IPList.length; i++) {
                this.IPList[i] = new String(source.IPList[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "IPTotalCount", this.IPTotalCount);
        this.setParamArraySimple(map, prefix + "IPList.", this.IPList);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

