/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.teo.v20220901.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeSecurityJSInjectionRuleResponse extends AbstractModel {

    /**
    * Specifies the total rule count for JavaScript injection.
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * JavaScript injection rule list.
    */
    @SerializedName("JSInjectionRules")
    @Expose
    private JSInjectionRule [] JSInjectionRules;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Specifies the total rule count for JavaScript injection. 
     * @return TotalCount Specifies the total rule count for JavaScript injection.
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Specifies the total rule count for JavaScript injection.
     * @param TotalCount Specifies the total rule count for JavaScript injection.
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get JavaScript injection rule list. 
     * @return JSInjectionRules JavaScript injection rule list.
     */
    public JSInjectionRule [] getJSInjectionRules() {
        return this.JSInjectionRules;
    }

    /**
     * Set JavaScript injection rule list.
     * @param JSInjectionRules JavaScript injection rule list.
     */
    public void setJSInjectionRules(JSInjectionRule [] JSInjectionRules) {
        this.JSInjectionRules = JSInjectionRules;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeSecurityJSInjectionRuleResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeSecurityJSInjectionRuleResponse(DescribeSecurityJSInjectionRuleResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.JSInjectionRules != null) {
            this.JSInjectionRules = new JSInjectionRule[source.JSInjectionRules.length];
            for (int i = 0; i < source.JSInjectionRules.length; i++) {
                this.JSInjectionRules[i] = new JSInjectionRule(source.JSInjectionRules[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArrayObj(map, prefix + "JSInjectionRules.", this.JSInjectionRules);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

