/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.teo.v20220901.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeZoneConfigImportResultResponse extends AbstractModel {

    /**
    * The status of this import task. Valid values: <li>success: It indicates the configuration was successfully imported;</li> <li>failure: It indicates the configuration import failed;</li> <li>doing: It indicates the configuration is being imported.</li>
    */
    @SerializedName("Status")
    @Expose
    private String Status;

    /**
    * The status message of this import task. If the configuration item import fails, you can view the failure cause through this field.
    */
    @SerializedName("Message")
    @Expose
    private String Message;

    /**
    * The configuration content of this import task.
    */
    @SerializedName("Content")
    @Expose
    private String Content;

    /**
    * The start time of this import task.
    */
    @SerializedName("ImportTime")
    @Expose
    private String ImportTime;

    /**
    * The end time of this import task.
    */
    @SerializedName("FinishTime")
    @Expose
    private String FinishTime;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get The status of this import task. Valid values: <li>success: It indicates the configuration was successfully imported;</li> <li>failure: It indicates the configuration import failed;</li> <li>doing: It indicates the configuration is being imported.</li> 
     * @return Status The status of this import task. Valid values: <li>success: It indicates the configuration was successfully imported;</li> <li>failure: It indicates the configuration import failed;</li> <li>doing: It indicates the configuration is being imported.</li>
     */
    public String getStatus() {
        return this.Status;
    }

    /**
     * Set The status of this import task. Valid values: <li>success: It indicates the configuration was successfully imported;</li> <li>failure: It indicates the configuration import failed;</li> <li>doing: It indicates the configuration is being imported.</li>
     * @param Status The status of this import task. Valid values: <li>success: It indicates the configuration was successfully imported;</li> <li>failure: It indicates the configuration import failed;</li> <li>doing: It indicates the configuration is being imported.</li>
     */
    public void setStatus(String Status) {
        this.Status = Status;
    }

    /**
     * Get The status message of this import task. If the configuration item import fails, you can view the failure cause through this field. 
     * @return Message The status message of this import task. If the configuration item import fails, you can view the failure cause through this field.
     */
    public String getMessage() {
        return this.Message;
    }

    /**
     * Set The status message of this import task. If the configuration item import fails, you can view the failure cause through this field.
     * @param Message The status message of this import task. If the configuration item import fails, you can view the failure cause through this field.
     */
    public void setMessage(String Message) {
        this.Message = Message;
    }

    /**
     * Get The configuration content of this import task. 
     * @return Content The configuration content of this import task.
     */
    public String getContent() {
        return this.Content;
    }

    /**
     * Set The configuration content of this import task.
     * @param Content The configuration content of this import task.
     */
    public void setContent(String Content) {
        this.Content = Content;
    }

    /**
     * Get The start time of this import task. 
     * @return ImportTime The start time of this import task.
     */
    public String getImportTime() {
        return this.ImportTime;
    }

    /**
     * Set The start time of this import task.
     * @param ImportTime The start time of this import task.
     */
    public void setImportTime(String ImportTime) {
        this.ImportTime = ImportTime;
    }

    /**
     * Get The end time of this import task. 
     * @return FinishTime The end time of this import task.
     */
    public String getFinishTime() {
        return this.FinishTime;
    }

    /**
     * Set The end time of this import task.
     * @param FinishTime The end time of this import task.
     */
    public void setFinishTime(String FinishTime) {
        this.FinishTime = FinishTime;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeZoneConfigImportResultResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeZoneConfigImportResultResponse(DescribeZoneConfigImportResultResponse source) {
        if (source.Status != null) {
            this.Status = new String(source.Status);
        }
        if (source.Message != null) {
            this.Message = new String(source.Message);
        }
        if (source.Content != null) {
            this.Content = new String(source.Content);
        }
        if (source.ImportTime != null) {
            this.ImportTime = new String(source.ImportTime);
        }
        if (source.FinishTime != null) {
            this.FinishTime = new String(source.FinishTime);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "Message", this.Message);
        this.setParamSimple(map, prefix + "Content", this.Content);
        this.setParamSimple(map, prefix + "ImportTime", this.ImportTime);
        this.setParamSimple(map, prefix + "FinishTime", this.FinishTime);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

