/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.teo.v20220901.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class IpTableConfig extends AbstractModel {

    /**
    * Switch. valid values:.
<li>`on`: Enable;</li>

<li>off: disabled;</li>.
    */
    @SerializedName("Switch")
    @Expose
    private String Switch;

    /**
    * Basic control rules. if null, historical configuration is used by default.
    */
    @SerializedName("IpTableRules")
    @Expose
    private IpTableRule [] IpTableRules;

    /**
     * Get Switch. valid values:.
<li>`on`: Enable;</li>

<li>off: disabled;</li>. 
     * @return Switch Switch. valid values:.
<li>`on`: Enable;</li>

<li>off: disabled;</li>.
     */
    public String getSwitch() {
        return this.Switch;
    }

    /**
     * Set Switch. valid values:.
<li>`on`: Enable;</li>

<li>off: disabled;</li>.
     * @param Switch Switch. valid values:.
<li>`on`: Enable;</li>

<li>off: disabled;</li>.
     */
    public void setSwitch(String Switch) {
        this.Switch = Switch;
    }

    /**
     * Get Basic control rules. if null, historical configuration is used by default. 
     * @return IpTableRules Basic control rules. if null, historical configuration is used by default.
     */
    public IpTableRule [] getIpTableRules() {
        return this.IpTableRules;
    }

    /**
     * Set Basic control rules. if null, historical configuration is used by default.
     * @param IpTableRules Basic control rules. if null, historical configuration is used by default.
     */
    public void setIpTableRules(IpTableRule [] IpTableRules) {
        this.IpTableRules = IpTableRules;
    }

    public IpTableConfig() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public IpTableConfig(IpTableConfig source) {
        if (source.Switch != null) {
            this.Switch = new String(source.Switch);
        }
        if (source.IpTableRules != null) {
            this.IpTableRules = new IpTableRule[source.IpTableRules.length];
            for (int i = 0; i < source.IpTableRules.length; i++) {
                this.IpTableRules[i] = new IpTableRule(source.IpTableRules[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Switch", this.Switch);
        this.setParamArrayObj(map, prefix + "IpTableRules.", this.IpTableRules);

    }
}

