/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tiw.v20190919.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeTranscodeResponse extends AbstractModel {

    /**
    * Total number of document pages
    */
    @SerializedName("Pages")
    @Expose
    private Long Pages;

    /**
    * Transcoding progress. Value range: 0 to 100
    */
    @SerializedName("Progress")
    @Expose
    private Long Progress;

    /**
    * Document resolution
    */
    @SerializedName("Resolution")
    @Expose
    private String Resolution;

    /**
    * URL of the transcoding result
Dynamic transcoding: link of the HTML5 page transcoded from a PowerPoint file
Static transcoding: URL prefix of the image transcoded for each document page. For example, if the URL prefix is `http://example.com/g0jb42ps49vtebjshilb/`, the image URL of the first page is
`http://example.com/g0jb42ps49vtebjshilb/1.jpg`, and so on.
    */
    @SerializedName("ResultUrl")
    @Expose
    private String ResultUrl;

    /**
    * Current task state
- QUEUED: queuing for transcoding
- PROCESSING: transcoding is in progress
- FINISHED: transcoded
    */
    @SerializedName("Status")
    @Expose
    private String Status;

    /**
    * Unique ID of the transcoding task
    */
    @SerializedName("TaskId")
    @Expose
    private String TaskId;

    /**
    * Document name
    */
    @SerializedName("Title")
    @Expose
    private String Title;

    /**
    * URL prefix of the thumbnail. If the URL prefix is `http://example.com/g0jb42ps49vtebjshilb/ `, the thumbnail URL for the first page of the dynamically transcoded PowerPoint file is
`http://example.com/g0jb42ps49vtebjshilb/1.jpg`, and so on.

If the document transcoding request carries the ThumbnailResolution parameter and the transcoding type is dynamic transcoding, this parameter is not null. In other cases, this parameter is null.
    */
    @SerializedName("ThumbnailUrl")
    @Expose
    private String ThumbnailUrl;

    /**
    * Resolution of the thumbnail generated for dynamic transcoding
    */
    @SerializedName("ThumbnailResolution")
    @Expose
    private String ThumbnailResolution;

    /**
    * URL for downloading the transcoded and compressed file. If `CompressFileType` carried in the document transcoding request is null or is not a supported compression format, this parameter is null.
    */
    @SerializedName("CompressFileUrl")
    @Expose
    private String CompressFileUrl;

    /**
    * Download URL (for trial) of the resource list.
Note: This parameter may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ResourceListUrl")
    @Expose
    private String ResourceListUrl;

    /**
    * Document generation mode (for trial).
Note: This parameter may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Ext")
    @Expose
    private String Ext;

    /**
    * Document transcoding task creation time, unit: seconds.
Note: This parameter may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("CreateTime")
    @Expose
    private Long CreateTime;

    /**
    * Document transcoding task assignment time, unit: seconds.
Note: This parameter may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("AssignTime")
    @Expose
    private Long AssignTime;

    /**
    * Document transcoding task finished time, unit: seconds.
Note: This parameter may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("FinishedTime")
    @Expose
    private Long FinishedTime;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of document pages 
     * @return Pages Total number of document pages
     */
    public Long getPages() {
        return this.Pages;
    }

    /**
     * Set Total number of document pages
     * @param Pages Total number of document pages
     */
    public void setPages(Long Pages) {
        this.Pages = Pages;
    }

    /**
     * Get Transcoding progress. Value range: 0 to 100 
     * @return Progress Transcoding progress. Value range: 0 to 100
     */
    public Long getProgress() {
        return this.Progress;
    }

    /**
     * Set Transcoding progress. Value range: 0 to 100
     * @param Progress Transcoding progress. Value range: 0 to 100
     */
    public void setProgress(Long Progress) {
        this.Progress = Progress;
    }

    /**
     * Get Document resolution 
     * @return Resolution Document resolution
     */
    public String getResolution() {
        return this.Resolution;
    }

    /**
     * Set Document resolution
     * @param Resolution Document resolution
     */
    public void setResolution(String Resolution) {
        this.Resolution = Resolution;
    }

    /**
     * Get URL of the transcoding result
Dynamic transcoding: link of the HTML5 page transcoded from a PowerPoint file
Static transcoding: URL prefix of the image transcoded for each document page. For example, if the URL prefix is `http://example.com/g0jb42ps49vtebjshilb/`, the image URL of the first page is
`http://example.com/g0jb42ps49vtebjshilb/1.jpg`, and so on. 
     * @return ResultUrl URL of the transcoding result
Dynamic transcoding: link of the HTML5 page transcoded from a PowerPoint file
Static transcoding: URL prefix of the image transcoded for each document page. For example, if the URL prefix is `http://example.com/g0jb42ps49vtebjshilb/`, the image URL of the first page is
`http://example.com/g0jb42ps49vtebjshilb/1.jpg`, and so on.
     */
    public String getResultUrl() {
        return this.ResultUrl;
    }

    /**
     * Set URL of the transcoding result
Dynamic transcoding: link of the HTML5 page transcoded from a PowerPoint file
Static transcoding: URL prefix of the image transcoded for each document page. For example, if the URL prefix is `http://example.com/g0jb42ps49vtebjshilb/`, the image URL of the first page is
`http://example.com/g0jb42ps49vtebjshilb/1.jpg`, and so on.
     * @param ResultUrl URL of the transcoding result
Dynamic transcoding: link of the HTML5 page transcoded from a PowerPoint file
Static transcoding: URL prefix of the image transcoded for each document page. For example, if the URL prefix is `http://example.com/g0jb42ps49vtebjshilb/`, the image URL of the first page is
`http://example.com/g0jb42ps49vtebjshilb/1.jpg`, and so on.
     */
    public void setResultUrl(String ResultUrl) {
        this.ResultUrl = ResultUrl;
    }

    /**
     * Get Current task state
- QUEUED: queuing for transcoding
- PROCESSING: transcoding is in progress
- FINISHED: transcoded 
     * @return Status Current task state
- QUEUED: queuing for transcoding
- PROCESSING: transcoding is in progress
- FINISHED: transcoded
     */
    public String getStatus() {
        return this.Status;
    }

    /**
     * Set Current task state
- QUEUED: queuing for transcoding
- PROCESSING: transcoding is in progress
- FINISHED: transcoded
     * @param Status Current task state
- QUEUED: queuing for transcoding
- PROCESSING: transcoding is in progress
- FINISHED: transcoded
     */
    public void setStatus(String Status) {
        this.Status = Status;
    }

    /**
     * Get Unique ID of the transcoding task 
     * @return TaskId Unique ID of the transcoding task
     */
    public String getTaskId() {
        return this.TaskId;
    }

    /**
     * Set Unique ID of the transcoding task
     * @param TaskId Unique ID of the transcoding task
     */
    public void setTaskId(String TaskId) {
        this.TaskId = TaskId;
    }

    /**
     * Get Document name 
     * @return Title Document name
     */
    public String getTitle() {
        return this.Title;
    }

    /**
     * Set Document name
     * @param Title Document name
     */
    public void setTitle(String Title) {
        this.Title = Title;
    }

    /**
     * Get URL prefix of the thumbnail. If the URL prefix is `http://example.com/g0jb42ps49vtebjshilb/ `, the thumbnail URL for the first page of the dynamically transcoded PowerPoint file is
`http://example.com/g0jb42ps49vtebjshilb/1.jpg`, and so on.

If the document transcoding request carries the ThumbnailResolution parameter and the transcoding type is dynamic transcoding, this parameter is not null. In other cases, this parameter is null. 
     * @return ThumbnailUrl URL prefix of the thumbnail. If the URL prefix is `http://example.com/g0jb42ps49vtebjshilb/ `, the thumbnail URL for the first page of the dynamically transcoded PowerPoint file is
`http://example.com/g0jb42ps49vtebjshilb/1.jpg`, and so on.

If the document transcoding request carries the ThumbnailResolution parameter and the transcoding type is dynamic transcoding, this parameter is not null. In other cases, this parameter is null.
     */
    public String getThumbnailUrl() {
        return this.ThumbnailUrl;
    }

    /**
     * Set URL prefix of the thumbnail. If the URL prefix is `http://example.com/g0jb42ps49vtebjshilb/ `, the thumbnail URL for the first page of the dynamically transcoded PowerPoint file is
`http://example.com/g0jb42ps49vtebjshilb/1.jpg`, and so on.

If the document transcoding request carries the ThumbnailResolution parameter and the transcoding type is dynamic transcoding, this parameter is not null. In other cases, this parameter is null.
     * @param ThumbnailUrl URL prefix of the thumbnail. If the URL prefix is `http://example.com/g0jb42ps49vtebjshilb/ `, the thumbnail URL for the first page of the dynamically transcoded PowerPoint file is
`http://example.com/g0jb42ps49vtebjshilb/1.jpg`, and so on.

If the document transcoding request carries the ThumbnailResolution parameter and the transcoding type is dynamic transcoding, this parameter is not null. In other cases, this parameter is null.
     */
    public void setThumbnailUrl(String ThumbnailUrl) {
        this.ThumbnailUrl = ThumbnailUrl;
    }

    /**
     * Get Resolution of the thumbnail generated for dynamic transcoding 
     * @return ThumbnailResolution Resolution of the thumbnail generated for dynamic transcoding
     */
    public String getThumbnailResolution() {
        return this.ThumbnailResolution;
    }

    /**
     * Set Resolution of the thumbnail generated for dynamic transcoding
     * @param ThumbnailResolution Resolution of the thumbnail generated for dynamic transcoding
     */
    public void setThumbnailResolution(String ThumbnailResolution) {
        this.ThumbnailResolution = ThumbnailResolution;
    }

    /**
     * Get URL for downloading the transcoded and compressed file. If `CompressFileType` carried in the document transcoding request is null or is not a supported compression format, this parameter is null. 
     * @return CompressFileUrl URL for downloading the transcoded and compressed file. If `CompressFileType` carried in the document transcoding request is null or is not a supported compression format, this parameter is null.
     */
    public String getCompressFileUrl() {
        return this.CompressFileUrl;
    }

    /**
     * Set URL for downloading the transcoded and compressed file. If `CompressFileType` carried in the document transcoding request is null or is not a supported compression format, this parameter is null.
     * @param CompressFileUrl URL for downloading the transcoded and compressed file. If `CompressFileType` carried in the document transcoding request is null or is not a supported compression format, this parameter is null.
     */
    public void setCompressFileUrl(String CompressFileUrl) {
        this.CompressFileUrl = CompressFileUrl;
    }

    /**
     * Get Download URL (for trial) of the resource list.
Note: This parameter may return null, indicating that no valid values can be obtained. 
     * @return ResourceListUrl Download URL (for trial) of the resource list.
Note: This parameter may return null, indicating that no valid values can be obtained.
     */
    public String getResourceListUrl() {
        return this.ResourceListUrl;
    }

    /**
     * Set Download URL (for trial) of the resource list.
Note: This parameter may return null, indicating that no valid values can be obtained.
     * @param ResourceListUrl Download URL (for trial) of the resource list.
Note: This parameter may return null, indicating that no valid values can be obtained.
     */
    public void setResourceListUrl(String ResourceListUrl) {
        this.ResourceListUrl = ResourceListUrl;
    }

    /**
     * Get Document generation mode (for trial).
Note: This parameter may return null, indicating that no valid values can be obtained. 
     * @return Ext Document generation mode (for trial).
Note: This parameter may return null, indicating that no valid values can be obtained.
     */
    public String getExt() {
        return this.Ext;
    }

    /**
     * Set Document generation mode (for trial).
Note: This parameter may return null, indicating that no valid values can be obtained.
     * @param Ext Document generation mode (for trial).
Note: This parameter may return null, indicating that no valid values can be obtained.
     */
    public void setExt(String Ext) {
        this.Ext = Ext;
    }

    /**
     * Get Document transcoding task creation time, unit: seconds.
Note: This parameter may return null, indicating that no valid values can be obtained. 
     * @return CreateTime Document transcoding task creation time, unit: seconds.
Note: This parameter may return null, indicating that no valid values can be obtained.
     */
    public Long getCreateTime() {
        return this.CreateTime;
    }

    /**
     * Set Document transcoding task creation time, unit: seconds.
Note: This parameter may return null, indicating that no valid values can be obtained.
     * @param CreateTime Document transcoding task creation time, unit: seconds.
Note: This parameter may return null, indicating that no valid values can be obtained.
     */
    public void setCreateTime(Long CreateTime) {
        this.CreateTime = CreateTime;
    }

    /**
     * Get Document transcoding task assignment time, unit: seconds.
Note: This parameter may return null, indicating that no valid values can be obtained. 
     * @return AssignTime Document transcoding task assignment time, unit: seconds.
Note: This parameter may return null, indicating that no valid values can be obtained.
     */
    public Long getAssignTime() {
        return this.AssignTime;
    }

    /**
     * Set Document transcoding task assignment time, unit: seconds.
Note: This parameter may return null, indicating that no valid values can be obtained.
     * @param AssignTime Document transcoding task assignment time, unit: seconds.
Note: This parameter may return null, indicating that no valid values can be obtained.
     */
    public void setAssignTime(Long AssignTime) {
        this.AssignTime = AssignTime;
    }

    /**
     * Get Document transcoding task finished time, unit: seconds.
Note: This parameter may return null, indicating that no valid values can be obtained. 
     * @return FinishedTime Document transcoding task finished time, unit: seconds.
Note: This parameter may return null, indicating that no valid values can be obtained.
     */
    public Long getFinishedTime() {
        return this.FinishedTime;
    }

    /**
     * Set Document transcoding task finished time, unit: seconds.
Note: This parameter may return null, indicating that no valid values can be obtained.
     * @param FinishedTime Document transcoding task finished time, unit: seconds.
Note: This parameter may return null, indicating that no valid values can be obtained.
     */
    public void setFinishedTime(Long FinishedTime) {
        this.FinishedTime = FinishedTime;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeTranscodeResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeTranscodeResponse(DescribeTranscodeResponse source) {
        if (source.Pages != null) {
            this.Pages = new Long(source.Pages);
        }
        if (source.Progress != null) {
            this.Progress = new Long(source.Progress);
        }
        if (source.Resolution != null) {
            this.Resolution = new String(source.Resolution);
        }
        if (source.ResultUrl != null) {
            this.ResultUrl = new String(source.ResultUrl);
        }
        if (source.Status != null) {
            this.Status = new String(source.Status);
        }
        if (source.TaskId != null) {
            this.TaskId = new String(source.TaskId);
        }
        if (source.Title != null) {
            this.Title = new String(source.Title);
        }
        if (source.ThumbnailUrl != null) {
            this.ThumbnailUrl = new String(source.ThumbnailUrl);
        }
        if (source.ThumbnailResolution != null) {
            this.ThumbnailResolution = new String(source.ThumbnailResolution);
        }
        if (source.CompressFileUrl != null) {
            this.CompressFileUrl = new String(source.CompressFileUrl);
        }
        if (source.ResourceListUrl != null) {
            this.ResourceListUrl = new String(source.ResourceListUrl);
        }
        if (source.Ext != null) {
            this.Ext = new String(source.Ext);
        }
        if (source.CreateTime != null) {
            this.CreateTime = new Long(source.CreateTime);
        }
        if (source.AssignTime != null) {
            this.AssignTime = new Long(source.AssignTime);
        }
        if (source.FinishedTime != null) {
            this.FinishedTime = new Long(source.FinishedTime);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Pages", this.Pages);
        this.setParamSimple(map, prefix + "Progress", this.Progress);
        this.setParamSimple(map, prefix + "Resolution", this.Resolution);
        this.setParamSimple(map, prefix + "ResultUrl", this.ResultUrl);
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "TaskId", this.TaskId);
        this.setParamSimple(map, prefix + "Title", this.Title);
        this.setParamSimple(map, prefix + "ThumbnailUrl", this.ThumbnailUrl);
        this.setParamSimple(map, prefix + "ThumbnailResolution", this.ThumbnailResolution);
        this.setParamSimple(map, prefix + "CompressFileUrl", this.CompressFileUrl);
        this.setParamSimple(map, prefix + "ResourceListUrl", this.ResourceListUrl);
        this.setParamSimple(map, prefix + "Ext", this.Ext);
        this.setParamSimple(map, prefix + "CreateTime", this.CreateTime);
        this.setParamSimple(map, prefix + "AssignTime", this.AssignTime);
        this.setParamSimple(map, prefix + "FinishedTime", this.FinishedTime);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

