/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tke.v20180525.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAvailableClusterVersionRequest extends AbstractModel {

    /**
    * Cluster ID. If you need to query the upgradable version of a specific cluster, this field is required.
    */
    @SerializedName("ClusterId")
    @Expose
    private String ClusterId;

    /**
    * Cluster ID list. If you need to query the upgradable versions of multiple clusters, this field is required.
    */
    @SerializedName("ClusterIds")
    @Expose
    private String [] ClusterIds;

    /**
     * Get Cluster ID. If you need to query the upgradable version of a specific cluster, this field is required. 
     * @return ClusterId Cluster ID. If you need to query the upgradable version of a specific cluster, this field is required.
     */
    public String getClusterId() {
        return this.ClusterId;
    }

    /**
     * Set Cluster ID. If you need to query the upgradable version of a specific cluster, this field is required.
     * @param ClusterId Cluster ID. If you need to query the upgradable version of a specific cluster, this field is required.
     */
    public void setClusterId(String ClusterId) {
        this.ClusterId = ClusterId;
    }

    /**
     * Get Cluster ID list. If you need to query the upgradable versions of multiple clusters, this field is required. 
     * @return ClusterIds Cluster ID list. If you need to query the upgradable versions of multiple clusters, this field is required.
     */
    public String [] getClusterIds() {
        return this.ClusterIds;
    }

    /**
     * Set Cluster ID list. If you need to query the upgradable versions of multiple clusters, this field is required.
     * @param ClusterIds Cluster ID list. If you need to query the upgradable versions of multiple clusters, this field is required.
     */
    public void setClusterIds(String [] ClusterIds) {
        this.ClusterIds = ClusterIds;
    }

    public DescribeAvailableClusterVersionRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAvailableClusterVersionRequest(DescribeAvailableClusterVersionRequest source) {
        if (source.ClusterId != null) {
            this.ClusterId = new String(source.ClusterId);
        }
        if (source.ClusterIds != null) {
            this.ClusterIds = new String[source.ClusterIds.length];
            for (int i = 0; i < source.ClusterIds.length; i++) {
                this.ClusterIds[i] = new String(source.ClusterIds[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ClusterId", this.ClusterId);
        this.setParamArraySimple(map, prefix + "ClusterIds.", this.ClusterIds);

    }
}

