/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tke.v20180525.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeBatchModifyTagsStatusResponse extends AbstractModel {

    /**
    * List of failed resources
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("FailedResources")
    @Expose
    private FailedResource [] FailedResources;

    /**
    * Task status:
- running
- failed
- done
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("Status")
    @Expose
    private String Status;

    /**
    * Whether to sync the subresource Tag within the cluster
    */
    @SerializedName("SyncSubresource")
    @Expose
    private Boolean SyncSubresource;

    /**
    * Cluster Tag
    */
    @SerializedName("Tags")
    @Expose
    private Tag [] Tags;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get List of failed resources
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return FailedResources List of failed resources
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public FailedResource [] getFailedResources() {
        return this.FailedResources;
    }

    /**
     * Set List of failed resources
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param FailedResources List of failed resources
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setFailedResources(FailedResource [] FailedResources) {
        this.FailedResources = FailedResources;
    }

    /**
     * Get Task status:
- running
- failed
- done
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return Status Task status:
- running
- failed
- done
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public String getStatus() {
        return this.Status;
    }

    /**
     * Set Task status:
- running
- failed
- done
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param Status Task status:
- running
- failed
- done
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setStatus(String Status) {
        this.Status = Status;
    }

    /**
     * Get Whether to sync the subresource Tag within the cluster 
     * @return SyncSubresource Whether to sync the subresource Tag within the cluster
     */
    public Boolean getSyncSubresource() {
        return this.SyncSubresource;
    }

    /**
     * Set Whether to sync the subresource Tag within the cluster
     * @param SyncSubresource Whether to sync the subresource Tag within the cluster
     */
    public void setSyncSubresource(Boolean SyncSubresource) {
        this.SyncSubresource = SyncSubresource;
    }

    /**
     * Get Cluster Tag 
     * @return Tags Cluster Tag
     */
    public Tag [] getTags() {
        return this.Tags;
    }

    /**
     * Set Cluster Tag
     * @param Tags Cluster Tag
     */
    public void setTags(Tag [] Tags) {
        this.Tags = Tags;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeBatchModifyTagsStatusResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeBatchModifyTagsStatusResponse(DescribeBatchModifyTagsStatusResponse source) {
        if (source.FailedResources != null) {
            this.FailedResources = new FailedResource[source.FailedResources.length];
            for (int i = 0; i < source.FailedResources.length; i++) {
                this.FailedResources[i] = new FailedResource(source.FailedResources[i]);
            }
        }
        if (source.Status != null) {
            this.Status = new String(source.Status);
        }
        if (source.SyncSubresource != null) {
            this.SyncSubresource = new Boolean(source.SyncSubresource);
        }
        if (source.Tags != null) {
            this.Tags = new Tag[source.Tags.length];
            for (int i = 0; i < source.Tags.length; i++) {
                this.Tags[i] = new Tag(source.Tags[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "FailedResources.", this.FailedResources);
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "SyncSubresource", this.SyncSubresource);
        this.setParamArrayObj(map, prefix + "Tags.", this.Tags);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

