/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tke.v20180525.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeClusterAsGroupsResponse extends AbstractModel {

    /**
    * Total number of scaling groups associated with the cluster
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * Cluster-associated scaling group list
    */
    @SerializedName("ClusterAsGroupSet")
    @Expose
    private ClusterAsGroup [] ClusterAsGroupSet;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of scaling groups associated with the cluster 
     * @return TotalCount Total number of scaling groups associated with the cluster
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set Total number of scaling groups associated with the cluster
     * @param TotalCount Total number of scaling groups associated with the cluster
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get Cluster-associated scaling group list 
     * @return ClusterAsGroupSet Cluster-associated scaling group list
     */
    public ClusterAsGroup [] getClusterAsGroupSet() {
        return this.ClusterAsGroupSet;
    }

    /**
     * Set Cluster-associated scaling group list
     * @param ClusterAsGroupSet Cluster-associated scaling group list
     */
    public void setClusterAsGroupSet(ClusterAsGroup [] ClusterAsGroupSet) {
        this.ClusterAsGroupSet = ClusterAsGroupSet;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeClusterAsGroupsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeClusterAsGroupsResponse(DescribeClusterAsGroupsResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.ClusterAsGroupSet != null) {
            this.ClusterAsGroupSet = new ClusterAsGroup[source.ClusterAsGroupSet.length];
            for (int i = 0; i < source.ClusterAsGroupSet.length; i++) {
                this.ClusterAsGroupSet[i] = new ClusterAsGroup(source.ClusterAsGroupSet[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArrayObj(map, prefix + "ClusterAsGroupSet.", this.ClusterAsGroupSet);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

