/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tke.v20180525.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeClusterKubeconfigResponse extends AbstractModel {

    /**
    * Sub-account kubeconfig file can be used to access the cluster kube-apiserver directly (if the "IsExtranet" parameter is false, it returns the kubeconfig for private network access, and the server will be a default domain name if the private network is not enabled; if the "IsExtranet" parameter is true, it returns the kubeconfig for public network access, and the server will be a default domain name if the public network is not enabled. The default domain name is not accessible by default and needs to be handled by the user).
    */
    @SerializedName("Kubeconfig")
    @Expose
    private String Kubeconfig;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Sub-account kubeconfig file can be used to access the cluster kube-apiserver directly (if the "IsExtranet" parameter is false, it returns the kubeconfig for private network access, and the server will be a default domain name if the private network is not enabled; if the "IsExtranet" parameter is true, it returns the kubeconfig for public network access, and the server will be a default domain name if the public network is not enabled. The default domain name is not accessible by default and needs to be handled by the user). 
     * @return Kubeconfig Sub-account kubeconfig file can be used to access the cluster kube-apiserver directly (if the "IsExtranet" parameter is false, it returns the kubeconfig for private network access, and the server will be a default domain name if the private network is not enabled; if the "IsExtranet" parameter is true, it returns the kubeconfig for public network access, and the server will be a default domain name if the public network is not enabled. The default domain name is not accessible by default and needs to be handled by the user).
     */
    public String getKubeconfig() {
        return this.Kubeconfig;
    }

    /**
     * Set Sub-account kubeconfig file can be used to access the cluster kube-apiserver directly (if the "IsExtranet" parameter is false, it returns the kubeconfig for private network access, and the server will be a default domain name if the private network is not enabled; if the "IsExtranet" parameter is true, it returns the kubeconfig for public network access, and the server will be a default domain name if the public network is not enabled. The default domain name is not accessible by default and needs to be handled by the user).
     * @param Kubeconfig Sub-account kubeconfig file can be used to access the cluster kube-apiserver directly (if the "IsExtranet" parameter is false, it returns the kubeconfig for private network access, and the server will be a default domain name if the private network is not enabled; if the "IsExtranet" parameter is true, it returns the kubeconfig for public network access, and the server will be a default domain name if the public network is not enabled. The default domain name is not accessible by default and needs to be handled by the user).
     */
    public void setKubeconfig(String Kubeconfig) {
        this.Kubeconfig = Kubeconfig;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeClusterKubeconfigResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeClusterKubeconfigResponse(DescribeClusterKubeconfigResponse source) {
        if (source.Kubeconfig != null) {
            this.Kubeconfig = new String(source.Kubeconfig);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Kubeconfig", this.Kubeconfig);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

