/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tke.v20180525.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeClusterSecurityRequest extends AbstractModel {

    /**
    * Cluster ID. Enter the ClusterId field returned by the DescribeClusters API
    */
    @SerializedName("ClusterId")
    @Expose
    private String ClusterId;

    /**
     * Get Cluster ID. Enter the ClusterId field returned by the DescribeClusters API 
     * @return ClusterId Cluster ID. Enter the ClusterId field returned by the DescribeClusters API
     */
    public String getClusterId() {
        return this.ClusterId;
    }

    /**
     * Set Cluster ID. Enter the ClusterId field returned by the DescribeClusters API
     * @param ClusterId Cluster ID. Enter the ClusterId field returned by the DescribeClusters API
     */
    public void setClusterId(String ClusterId) {
        this.ClusterId = ClusterId;
    }

    public DescribeClusterSecurityRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeClusterSecurityRequest(DescribeClusterSecurityRequest source) {
        if (source.ClusterId != null) {
            this.ClusterId = new String(source.ClusterId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ClusterId", this.ClusterId);

    }
}

