/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tke.v20180525.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeExternalNodeSupportConfigResponse extends AbstractModel {

    /**
    * CIDR used to assign container and service IPs for the cluster. It cannot conflict with the VPC's CIDR or the CIDRs of other clusters in the same VPC. The network segment must be within the private network segment, for example, 10.1.0.0/14, 192.168.0.1/18,172.16.0.0/16.

Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("ClusterCIDR")
    @Expose
    private String ClusterCIDR;

    /**
    * Cluster network plugin type, support: CiliumBGP, CiliumVXLan
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("NetworkType")
    @Expose
    private String NetworkType;

    /**
    * Subnet ID

Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("SubnetId")
    @Expose
    private String SubnetId;

    /**
    * Whether to enable third-party node direct connect support
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("Enabled")
    @Expose
    private Boolean Enabled;

    /**
    * BGP AS number of the switch to which the node belongs
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("AS")
    @Expose
    private String AS;

    /**
    * Switch IP of the switch to which the node belongs
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("SwitchIP")
    @Expose
    private String SwitchIP;

    /**
    * Enabling third-party node pool status
    */
    @SerializedName("Status")
    @Expose
    private String Status;

    /**
    * Reason if enabling failed
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("FailedReason")
    @Expose
    private String FailedReason;

    /**
    * Private Network Access Address
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("Master")
    @Expose
    private String Master;

    /**
    * Image Repository Proxy Address
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("Proxy")
    @Expose
    private String Proxy;

    /**
    * Used to record which step the enabling of external nodes process is at
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("Progress")
    @Expose
    private Step [] Progress;

    /**
    * Whether to enable third-party node public network connection support
    */
    @SerializedName("EnabledPublicConnect")
    @Expose
    private Boolean EnabledPublicConnect;

    /**
    * Public Network Connection Address of the registered node public network version
    */
    @SerializedName("PublicConnectUrl")
    @Expose
    private String PublicConnectUrl;

    /**
    * Custom Domain Name of the registered node public network version
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("PublicCustomDomain")
    @Expose
    private String PublicCustomDomain;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get CIDR used to assign container and service IPs for the cluster. It cannot conflict with the VPC's CIDR or the CIDRs of other clusters in the same VPC. The network segment must be within the private network segment, for example, 10.1.0.0/14, 192.168.0.1/18,172.16.0.0/16.

Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return ClusterCIDR CIDR used to assign container and service IPs for the cluster. It cannot conflict with the VPC's CIDR or the CIDRs of other clusters in the same VPC. The network segment must be within the private network segment, for example, 10.1.0.0/14, 192.168.0.1/18,172.16.0.0/16.

Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public String getClusterCIDR() {
        return this.ClusterCIDR;
    }

    /**
     * Set CIDR used to assign container and service IPs for the cluster. It cannot conflict with the VPC's CIDR or the CIDRs of other clusters in the same VPC. The network segment must be within the private network segment, for example, 10.1.0.0/14, 192.168.0.1/18,172.16.0.0/16.

Note: This field may return "null", indicating that no valid value can be obtained.
     * @param ClusterCIDR CIDR used to assign container and service IPs for the cluster. It cannot conflict with the VPC's CIDR or the CIDRs of other clusters in the same VPC. The network segment must be within the private network segment, for example, 10.1.0.0/14, 192.168.0.1/18,172.16.0.0/16.

Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setClusterCIDR(String ClusterCIDR) {
        this.ClusterCIDR = ClusterCIDR;
    }

    /**
     * Get Cluster network plugin type, support: CiliumBGP, CiliumVXLan
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return NetworkType Cluster network plugin type, support: CiliumBGP, CiliumVXLan
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public String getNetworkType() {
        return this.NetworkType;
    }

    /**
     * Set Cluster network plugin type, support: CiliumBGP, CiliumVXLan
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param NetworkType Cluster network plugin type, support: CiliumBGP, CiliumVXLan
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setNetworkType(String NetworkType) {
        this.NetworkType = NetworkType;
    }

    /**
     * Get Subnet ID

Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return SubnetId Subnet ID

Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public String getSubnetId() {
        return this.SubnetId;
    }

    /**
     * Set Subnet ID

Note: This field may return "null", indicating that no valid value can be obtained.
     * @param SubnetId Subnet ID

Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setSubnetId(String SubnetId) {
        this.SubnetId = SubnetId;
    }

    /**
     * Get Whether to enable third-party node direct connect support
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return Enabled Whether to enable third-party node direct connect support
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public Boolean getEnabled() {
        return this.Enabled;
    }

    /**
     * Set Whether to enable third-party node direct connect support
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param Enabled Whether to enable third-party node direct connect support
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setEnabled(Boolean Enabled) {
        this.Enabled = Enabled;
    }

    /**
     * Get BGP AS number of the switch to which the node belongs
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return AS BGP AS number of the switch to which the node belongs
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public String getAS() {
        return this.AS;
    }

    /**
     * Set BGP AS number of the switch to which the node belongs
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param AS BGP AS number of the switch to which the node belongs
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setAS(String AS) {
        this.AS = AS;
    }

    /**
     * Get Switch IP of the switch to which the node belongs
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return SwitchIP Switch IP of the switch to which the node belongs
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public String getSwitchIP() {
        return this.SwitchIP;
    }

    /**
     * Set Switch IP of the switch to which the node belongs
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param SwitchIP Switch IP of the switch to which the node belongs
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setSwitchIP(String SwitchIP) {
        this.SwitchIP = SwitchIP;
    }

    /**
     * Get Enabling third-party node pool status 
     * @return Status Enabling third-party node pool status
     */
    public String getStatus() {
        return this.Status;
    }

    /**
     * Set Enabling third-party node pool status
     * @param Status Enabling third-party node pool status
     */
    public void setStatus(String Status) {
        this.Status = Status;
    }

    /**
     * Get Reason if enabling failed
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return FailedReason Reason if enabling failed
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public String getFailedReason() {
        return this.FailedReason;
    }

    /**
     * Set Reason if enabling failed
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param FailedReason Reason if enabling failed
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setFailedReason(String FailedReason) {
        this.FailedReason = FailedReason;
    }

    /**
     * Get Private Network Access Address
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return Master Private Network Access Address
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public String getMaster() {
        return this.Master;
    }

    /**
     * Set Private Network Access Address
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param Master Private Network Access Address
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setMaster(String Master) {
        this.Master = Master;
    }

    /**
     * Get Image Repository Proxy Address
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return Proxy Image Repository Proxy Address
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public String getProxy() {
        return this.Proxy;
    }

    /**
     * Set Image Repository Proxy Address
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param Proxy Image Repository Proxy Address
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setProxy(String Proxy) {
        this.Proxy = Proxy;
    }

    /**
     * Get Used to record which step the enabling of external nodes process is at
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return Progress Used to record which step the enabling of external nodes process is at
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public Step [] getProgress() {
        return this.Progress;
    }

    /**
     * Set Used to record which step the enabling of external nodes process is at
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param Progress Used to record which step the enabling of external nodes process is at
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setProgress(Step [] Progress) {
        this.Progress = Progress;
    }

    /**
     * Get Whether to enable third-party node public network connection support 
     * @return EnabledPublicConnect Whether to enable third-party node public network connection support
     */
    public Boolean getEnabledPublicConnect() {
        return this.EnabledPublicConnect;
    }

    /**
     * Set Whether to enable third-party node public network connection support
     * @param EnabledPublicConnect Whether to enable third-party node public network connection support
     */
    public void setEnabledPublicConnect(Boolean EnabledPublicConnect) {
        this.EnabledPublicConnect = EnabledPublicConnect;
    }

    /**
     * Get Public Network Connection Address of the registered node public network version 
     * @return PublicConnectUrl Public Network Connection Address of the registered node public network version
     */
    public String getPublicConnectUrl() {
        return this.PublicConnectUrl;
    }

    /**
     * Set Public Network Connection Address of the registered node public network version
     * @param PublicConnectUrl Public Network Connection Address of the registered node public network version
     */
    public void setPublicConnectUrl(String PublicConnectUrl) {
        this.PublicConnectUrl = PublicConnectUrl;
    }

    /**
     * Get Custom Domain Name of the registered node public network version
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return PublicCustomDomain Custom Domain Name of the registered node public network version
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public String getPublicCustomDomain() {
        return this.PublicCustomDomain;
    }

    /**
     * Set Custom Domain Name of the registered node public network version
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param PublicCustomDomain Custom Domain Name of the registered node public network version
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setPublicCustomDomain(String PublicCustomDomain) {
        this.PublicCustomDomain = PublicCustomDomain;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeExternalNodeSupportConfigResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeExternalNodeSupportConfigResponse(DescribeExternalNodeSupportConfigResponse source) {
        if (source.ClusterCIDR != null) {
            this.ClusterCIDR = new String(source.ClusterCIDR);
        }
        if (source.NetworkType != null) {
            this.NetworkType = new String(source.NetworkType);
        }
        if (source.SubnetId != null) {
            this.SubnetId = new String(source.SubnetId);
        }
        if (source.Enabled != null) {
            this.Enabled = new Boolean(source.Enabled);
        }
        if (source.AS != null) {
            this.AS = new String(source.AS);
        }
        if (source.SwitchIP != null) {
            this.SwitchIP = new String(source.SwitchIP);
        }
        if (source.Status != null) {
            this.Status = new String(source.Status);
        }
        if (source.FailedReason != null) {
            this.FailedReason = new String(source.FailedReason);
        }
        if (source.Master != null) {
            this.Master = new String(source.Master);
        }
        if (source.Proxy != null) {
            this.Proxy = new String(source.Proxy);
        }
        if (source.Progress != null) {
            this.Progress = new Step[source.Progress.length];
            for (int i = 0; i < source.Progress.length; i++) {
                this.Progress[i] = new Step(source.Progress[i]);
            }
        }
        if (source.EnabledPublicConnect != null) {
            this.EnabledPublicConnect = new Boolean(source.EnabledPublicConnect);
        }
        if (source.PublicConnectUrl != null) {
            this.PublicConnectUrl = new String(source.PublicConnectUrl);
        }
        if (source.PublicCustomDomain != null) {
            this.PublicCustomDomain = new String(source.PublicCustomDomain);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ClusterCIDR", this.ClusterCIDR);
        this.setParamSimple(map, prefix + "NetworkType", this.NetworkType);
        this.setParamSimple(map, prefix + "SubnetId", this.SubnetId);
        this.setParamSimple(map, prefix + "Enabled", this.Enabled);
        this.setParamSimple(map, prefix + "AS", this.AS);
        this.setParamSimple(map, prefix + "SwitchIP", this.SwitchIP);
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "FailedReason", this.FailedReason);
        this.setParamSimple(map, prefix + "Master", this.Master);
        this.setParamSimple(map, prefix + "Proxy", this.Proxy);
        this.setParamArrayObj(map, prefix + "Progress.", this.Progress);
        this.setParamSimple(map, prefix + "EnabledPublicConnect", this.EnabledPublicConnect);
        this.setParamSimple(map, prefix + "PublicConnectUrl", this.PublicConnectUrl);
        this.setParamSimple(map, prefix + "PublicCustomDomain", this.PublicCustomDomain);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

