/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tke.v20180525.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeIPAMDResponse extends AbstractModel {

    /**
    * Is the eniipamd component installed?
    */
    @SerializedName("EnableIPAMD")
    @Expose
    private Boolean EnableIPAMD;

    /**
    * Is custom podcidr enabled? It is false by default. It only matters if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("EnableCustomizedPodCidr")
    @Expose
    private Boolean EnableCustomizedPodCidr;

    /**
    * Is vpccni mode disabled? It is false by default. It only matters if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("DisableVpcCniMode")
    @Expose
    private Boolean DisableVpcCniMode;

    /**
    * Component status. The value is available only if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("Phase")
    @Expose
    private String Phase;

    /**
    * Error message. It is available only if the eniipamd component is installed and the status is not running.
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("Reason")
    @Expose
    private String Reason;

    /**
    * Subnet information. It is available only if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("SubnetIds")
    @Expose
    private String [] SubnetIds;

    /**
    * Fixed IP recycling time. It is available only if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("ClaimExpiredDuration")
    @Expose
    private String ClaimExpiredDuration;

    /**
    * Is the relay network card mode enabled?
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("EnableTrunkingENI")
    @Expose
    private Boolean EnableTrunkingENI;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Is the eniipamd component installed? 
     * @return EnableIPAMD Is the eniipamd component installed?
     */
    public Boolean getEnableIPAMD() {
        return this.EnableIPAMD;
    }

    /**
     * Set Is the eniipamd component installed?
     * @param EnableIPAMD Is the eniipamd component installed?
     */
    public void setEnableIPAMD(Boolean EnableIPAMD) {
        this.EnableIPAMD = EnableIPAMD;
    }

    /**
     * Get Is custom podcidr enabled? It is false by default. It only matters if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return EnableCustomizedPodCidr Is custom podcidr enabled? It is false by default. It only matters if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public Boolean getEnableCustomizedPodCidr() {
        return this.EnableCustomizedPodCidr;
    }

    /**
     * Set Is custom podcidr enabled? It is false by default. It only matters if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param EnableCustomizedPodCidr Is custom podcidr enabled? It is false by default. It only matters if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setEnableCustomizedPodCidr(Boolean EnableCustomizedPodCidr) {
        this.EnableCustomizedPodCidr = EnableCustomizedPodCidr;
    }

    /**
     * Get Is vpccni mode disabled? It is false by default. It only matters if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return DisableVpcCniMode Is vpccni mode disabled? It is false by default. It only matters if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public Boolean getDisableVpcCniMode() {
        return this.DisableVpcCniMode;
    }

    /**
     * Set Is vpccni mode disabled? It is false by default. It only matters if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param DisableVpcCniMode Is vpccni mode disabled? It is false by default. It only matters if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setDisableVpcCniMode(Boolean DisableVpcCniMode) {
        this.DisableVpcCniMode = DisableVpcCniMode;
    }

    /**
     * Get Component status. The value is available only if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return Phase Component status. The value is available only if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public String getPhase() {
        return this.Phase;
    }

    /**
     * Set Component status. The value is available only if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param Phase Component status. The value is available only if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setPhase(String Phase) {
        this.Phase = Phase;
    }

    /**
     * Get Error message. It is available only if the eniipamd component is installed and the status is not running.
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return Reason Error message. It is available only if the eniipamd component is installed and the status is not running.
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public String getReason() {
        return this.Reason;
    }

    /**
     * Set Error message. It is available only if the eniipamd component is installed and the status is not running.
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param Reason Error message. It is available only if the eniipamd component is installed and the status is not running.
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setReason(String Reason) {
        this.Reason = Reason;
    }

    /**
     * Get Subnet information. It is available only if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return SubnetIds Subnet information. It is available only if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public String [] getSubnetIds() {
        return this.SubnetIds;
    }

    /**
     * Set Subnet information. It is available only if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param SubnetIds Subnet information. It is available only if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setSubnetIds(String [] SubnetIds) {
        this.SubnetIds = SubnetIds;
    }

    /**
     * Get Fixed IP recycling time. It is available only if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return ClaimExpiredDuration Fixed IP recycling time. It is available only if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public String getClaimExpiredDuration() {
        return this.ClaimExpiredDuration;
    }

    /**
     * Set Fixed IP recycling time. It is available only if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param ClaimExpiredDuration Fixed IP recycling time. It is available only if the eniipamd component is installed.
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setClaimExpiredDuration(String ClaimExpiredDuration) {
        this.ClaimExpiredDuration = ClaimExpiredDuration;
    }

    /**
     * Get Is the relay network card mode enabled?
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return EnableTrunkingENI Is the relay network card mode enabled?
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public Boolean getEnableTrunkingENI() {
        return this.EnableTrunkingENI;
    }

    /**
     * Set Is the relay network card mode enabled?
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param EnableTrunkingENI Is the relay network card mode enabled?
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setEnableTrunkingENI(Boolean EnableTrunkingENI) {
        this.EnableTrunkingENI = EnableTrunkingENI;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeIPAMDResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeIPAMDResponse(DescribeIPAMDResponse source) {
        if (source.EnableIPAMD != null) {
            this.EnableIPAMD = new Boolean(source.EnableIPAMD);
        }
        if (source.EnableCustomizedPodCidr != null) {
            this.EnableCustomizedPodCidr = new Boolean(source.EnableCustomizedPodCidr);
        }
        if (source.DisableVpcCniMode != null) {
            this.DisableVpcCniMode = new Boolean(source.DisableVpcCniMode);
        }
        if (source.Phase != null) {
            this.Phase = new String(source.Phase);
        }
        if (source.Reason != null) {
            this.Reason = new String(source.Reason);
        }
        if (source.SubnetIds != null) {
            this.SubnetIds = new String[source.SubnetIds.length];
            for (int i = 0; i < source.SubnetIds.length; i++) {
                this.SubnetIds[i] = new String(source.SubnetIds[i]);
            }
        }
        if (source.ClaimExpiredDuration != null) {
            this.ClaimExpiredDuration = new String(source.ClaimExpiredDuration);
        }
        if (source.EnableTrunkingENI != null) {
            this.EnableTrunkingENI = new Boolean(source.EnableTrunkingENI);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "EnableIPAMD", this.EnableIPAMD);
        this.setParamSimple(map, prefix + "EnableCustomizedPodCidr", this.EnableCustomizedPodCidr);
        this.setParamSimple(map, prefix + "DisableVpcCniMode", this.DisableVpcCniMode);
        this.setParamSimple(map, prefix + "Phase", this.Phase);
        this.setParamSimple(map, prefix + "Reason", this.Reason);
        this.setParamArraySimple(map, prefix + "SubnetIds.", this.SubnetIds);
        this.setParamSimple(map, prefix + "ClaimExpiredDuration", this.ClaimExpiredDuration);
        this.setParamSimple(map, prefix + "EnableTrunkingENI", this.EnableTrunkingENI);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

