/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tke.v20180525.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeLogConfigsResponse extends AbstractModel {

    /**
    * Total number of collection rules when performing paged search
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("Total")
    @Expose
    private Long Total;

    /**
    * Search by specified collection rule name. If partially failed, the failed collection rule name and the last failure reason will be returned.
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("Message")
    @Expose
    private String Message;

    /**
    * Collection rule query results
Note: This field may return "null", indicating that no valid value can be obtained.
    */
    @SerializedName("LogConfigs")
    @Expose
    private String LogConfigs;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of collection rules when performing paged search
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return Total Total number of collection rules when performing paged search
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public Long getTotal() {
        return this.Total;
    }

    /**
     * Set Total number of collection rules when performing paged search
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param Total Total number of collection rules when performing paged search
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setTotal(Long Total) {
        this.Total = Total;
    }

    /**
     * Get Search by specified collection rule name. If partially failed, the failed collection rule name and the last failure reason will be returned.
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return Message Search by specified collection rule name. If partially failed, the failed collection rule name and the last failure reason will be returned.
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public String getMessage() {
        return this.Message;
    }

    /**
     * Set Search by specified collection rule name. If partially failed, the failed collection rule name and the last failure reason will be returned.
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param Message Search by specified collection rule name. If partially failed, the failed collection rule name and the last failure reason will be returned.
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setMessage(String Message) {
        this.Message = Message;
    }

    /**
     * Get Collection rule query results
Note: This field may return "null", indicating that no valid value can be obtained. 
     * @return LogConfigs Collection rule query results
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public String getLogConfigs() {
        return this.LogConfigs;
    }

    /**
     * Set Collection rule query results
Note: This field may return "null", indicating that no valid value can be obtained.
     * @param LogConfigs Collection rule query results
Note: This field may return "null", indicating that no valid value can be obtained.
     */
    public void setLogConfigs(String LogConfigs) {
        this.LogConfigs = LogConfigs;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeLogConfigsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeLogConfigsResponse(DescribeLogConfigsResponse source) {
        if (source.Total != null) {
            this.Total = new Long(source.Total);
        }
        if (source.Message != null) {
            this.Message = new String(source.Message);
        }
        if (source.LogConfigs != null) {
            this.LogConfigs = new String(source.LogConfigs);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Total", this.Total);
        this.setParamSimple(map, prefix + "Message", this.Message);
        this.setParamSimple(map, prefix + "LogConfigs", this.LogConfigs);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

