/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tke.v20180525.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeReservedInstanceUtilizationRateResponse extends AbstractModel {

    /**
    * Usage Rate of Reserved Coupons 
    */
    @SerializedName("UtilizationRateSet")
    @Expose
    private ReservedInstanceUtilizationRate [] UtilizationRateSet;

    /**
    * Total number of pay-as-you-go Pods
    */
    @SerializedName("PodNum")
    @Expose
    private Long PodNum;

    /**
    *  Pod Deduction Rate by Reserved Coupons
    */
    @SerializedName("PodRate")
    @Expose
    private Float PodRate;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Usage Rate of Reserved Coupons  
     * @return UtilizationRateSet Usage Rate of Reserved Coupons 
     */
    public ReservedInstanceUtilizationRate [] getUtilizationRateSet() {
        return this.UtilizationRateSet;
    }

    /**
     * Set Usage Rate of Reserved Coupons 
     * @param UtilizationRateSet Usage Rate of Reserved Coupons 
     */
    public void setUtilizationRateSet(ReservedInstanceUtilizationRate [] UtilizationRateSet) {
        this.UtilizationRateSet = UtilizationRateSet;
    }

    /**
     * Get Total number of pay-as-you-go Pods 
     * @return PodNum Total number of pay-as-you-go Pods
     */
    public Long getPodNum() {
        return this.PodNum;
    }

    /**
     * Set Total number of pay-as-you-go Pods
     * @param PodNum Total number of pay-as-you-go Pods
     */
    public void setPodNum(Long PodNum) {
        this.PodNum = PodNum;
    }

    /**
     * Get  Pod Deduction Rate by Reserved Coupons 
     * @return PodRate  Pod Deduction Rate by Reserved Coupons
     */
    public Float getPodRate() {
        return this.PodRate;
    }

    /**
     * Set  Pod Deduction Rate by Reserved Coupons
     * @param PodRate  Pod Deduction Rate by Reserved Coupons
     */
    public void setPodRate(Float PodRate) {
        this.PodRate = PodRate;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeReservedInstanceUtilizationRateResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeReservedInstanceUtilizationRateResponse(DescribeReservedInstanceUtilizationRateResponse source) {
        if (source.UtilizationRateSet != null) {
            this.UtilizationRateSet = new ReservedInstanceUtilizationRate[source.UtilizationRateSet.length];
            for (int i = 0; i < source.UtilizationRateSet.length; i++) {
                this.UtilizationRateSet[i] = new ReservedInstanceUtilizationRate(source.UtilizationRateSet[i]);
            }
        }
        if (source.PodNum != null) {
            this.PodNum = new Long(source.PodNum);
        }
        if (source.PodRate != null) {
            this.PodRate = new Float(source.PodRate);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "UtilizationRateSet.", this.UtilizationRateSet);
        this.setParamSimple(map, prefix + "PodNum", this.PodNum);
        this.setParamSimple(map, prefix + "PodRate", this.PodRate);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

