/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tke.v20180525.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeTKEEdgeScriptResponse extends AbstractModel {

    /**
    * Whether to download the link
    */
    @SerializedName("Link")
    @Expose
    private String Link;

    /**
    * Whether to download the desired token
    */
    @SerializedName("Token")
    @Expose
    private String Token;

    /**
    * Whether to download the command
    */
    @SerializedName("Command")
    @Expose
    private String Command;

    /**
    * Version of edgectl script. The latest version is obtained by default.
Note: This field may return `null`, indicating that no valid values can be obtained.
    */
    @SerializedName("ScriptVersion")
    @Expose
    private String ScriptVersion;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Whether to download the link 
     * @return Link Whether to download the link
     */
    public String getLink() {
        return this.Link;
    }

    /**
     * Set Whether to download the link
     * @param Link Whether to download the link
     */
    public void setLink(String Link) {
        this.Link = Link;
    }

    /**
     * Get Whether to download the desired token 
     * @return Token Whether to download the desired token
     */
    public String getToken() {
        return this.Token;
    }

    /**
     * Set Whether to download the desired token
     * @param Token Whether to download the desired token
     */
    public void setToken(String Token) {
        this.Token = Token;
    }

    /**
     * Get Whether to download the command 
     * @return Command Whether to download the command
     */
    public String getCommand() {
        return this.Command;
    }

    /**
     * Set Whether to download the command
     * @param Command Whether to download the command
     */
    public void setCommand(String Command) {
        this.Command = Command;
    }

    /**
     * Get Version of edgectl script. The latest version is obtained by default.
Note: This field may return `null`, indicating that no valid values can be obtained. 
     * @return ScriptVersion Version of edgectl script. The latest version is obtained by default.
Note: This field may return `null`, indicating that no valid values can be obtained.
     */
    public String getScriptVersion() {
        return this.ScriptVersion;
    }

    /**
     * Set Version of edgectl script. The latest version is obtained by default.
Note: This field may return `null`, indicating that no valid values can be obtained.
     * @param ScriptVersion Version of edgectl script. The latest version is obtained by default.
Note: This field may return `null`, indicating that no valid values can be obtained.
     */
    public void setScriptVersion(String ScriptVersion) {
        this.ScriptVersion = ScriptVersion;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeTKEEdgeScriptResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeTKEEdgeScriptResponse(DescribeTKEEdgeScriptResponse source) {
        if (source.Link != null) {
            this.Link = new String(source.Link);
        }
        if (source.Token != null) {
            this.Token = new String(source.Token);
        }
        if (source.Command != null) {
            this.Command = new String(source.Command);
        }
        if (source.ScriptVersion != null) {
            this.ScriptVersion = new String(source.ScriptVersion);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Link", this.Link);
        this.setParamSimple(map, prefix + "Token", this.Token);
        this.setParamSimple(map, prefix + "Command", this.Command);
        this.setParamSimple(map, prefix + "ScriptVersion", this.ScriptVersion);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

