/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.trabbit.v20230418.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeRabbitMQServerlessExchangesRequest extends AbstractModel {

    /**
    * Instance id.
    */
    @SerializedName("InstanceId")
    @Expose
    private String InstanceId;

    /**
    * Specifies the vhost parameter.
    */
    @SerializedName("VirtualHost")
    @Expose
    private String VirtualHost;

    /**
    * Paging offset.
    */
    @SerializedName("Offset")
    @Expose
    private Long Offset;

    /**
    * Paginate limit.
    */
    @SerializedName("Limit")
    @Expose
    private Long Limit;

    /**
    * Search keywords support fuzzy matching.
    */
    @SerializedName("SearchWord")
    @Expose
    private String SearchWord;

    /**
    * Specifies the filter type for each selected element in the array of exchange types.
    */
    @SerializedName("ExchangeTypeFilters")
    @Expose
    private String [] ExchangeTypeFilters;

    /**
    * Specifies the exchange creation source. valid values: "system" (generated by the system), "user" (user-created).
    */
    @SerializedName("ExchangeCreatorFilters")
    @Expose
    private String [] ExchangeCreatorFilters;

    /**
    * exchange name. specifies that it is used for exact matching.
    */
    @SerializedName("ExchangeName")
    @Expose
    private String ExchangeName;

    /**
    * Sorting field.
MessageRateInOut specifies the total production and consumption rate.
MessageRateIn specifies the production rate.
MessageRateOut specifies the consumption rate.
    */
    @SerializedName("SortElement")
    @Expose
    private String SortElement;

    /**
    * Sort order. valid values: ascend or descend.
    */
    @SerializedName("SortOrder")
    @Expose
    private String SortOrder;

    /**
     * Get Instance id. 
     * @return InstanceId Instance id.
     */
    public String getInstanceId() {
        return this.InstanceId;
    }

    /**
     * Set Instance id.
     * @param InstanceId Instance id.
     */
    public void setInstanceId(String InstanceId) {
        this.InstanceId = InstanceId;
    }

    /**
     * Get Specifies the vhost parameter. 
     * @return VirtualHost Specifies the vhost parameter.
     */
    public String getVirtualHost() {
        return this.VirtualHost;
    }

    /**
     * Set Specifies the vhost parameter.
     * @param VirtualHost Specifies the vhost parameter.
     */
    public void setVirtualHost(String VirtualHost) {
        this.VirtualHost = VirtualHost;
    }

    /**
     * Get Paging offset. 
     * @return Offset Paging offset.
     */
    public Long getOffset() {
        return this.Offset;
    }

    /**
     * Set Paging offset.
     * @param Offset Paging offset.
     */
    public void setOffset(Long Offset) {
        this.Offset = Offset;
    }

    /**
     * Get Paginate limit. 
     * @return Limit Paginate limit.
     */
    public Long getLimit() {
        return this.Limit;
    }

    /**
     * Set Paginate limit.
     * @param Limit Paginate limit.
     */
    public void setLimit(Long Limit) {
        this.Limit = Limit;
    }

    /**
     * Get Search keywords support fuzzy matching. 
     * @return SearchWord Search keywords support fuzzy matching.
     */
    public String getSearchWord() {
        return this.SearchWord;
    }

    /**
     * Set Search keywords support fuzzy matching.
     * @param SearchWord Search keywords support fuzzy matching.
     */
    public void setSearchWord(String SearchWord) {
        this.SearchWord = SearchWord;
    }

    /**
     * Get Specifies the filter type for each selected element in the array of exchange types. 
     * @return ExchangeTypeFilters Specifies the filter type for each selected element in the array of exchange types.
     */
    public String [] getExchangeTypeFilters() {
        return this.ExchangeTypeFilters;
    }

    /**
     * Set Specifies the filter type for each selected element in the array of exchange types.
     * @param ExchangeTypeFilters Specifies the filter type for each selected element in the array of exchange types.
     */
    public void setExchangeTypeFilters(String [] ExchangeTypeFilters) {
        this.ExchangeTypeFilters = ExchangeTypeFilters;
    }

    /**
     * Get Specifies the exchange creation source. valid values: "system" (generated by the system), "user" (user-created). 
     * @return ExchangeCreatorFilters Specifies the exchange creation source. valid values: "system" (generated by the system), "user" (user-created).
     */
    public String [] getExchangeCreatorFilters() {
        return this.ExchangeCreatorFilters;
    }

    /**
     * Set Specifies the exchange creation source. valid values: "system" (generated by the system), "user" (user-created).
     * @param ExchangeCreatorFilters Specifies the exchange creation source. valid values: "system" (generated by the system), "user" (user-created).
     */
    public void setExchangeCreatorFilters(String [] ExchangeCreatorFilters) {
        this.ExchangeCreatorFilters = ExchangeCreatorFilters;
    }

    /**
     * Get exchange name. specifies that it is used for exact matching. 
     * @return ExchangeName exchange name. specifies that it is used for exact matching.
     */
    public String getExchangeName() {
        return this.ExchangeName;
    }

    /**
     * Set exchange name. specifies that it is used for exact matching.
     * @param ExchangeName exchange name. specifies that it is used for exact matching.
     */
    public void setExchangeName(String ExchangeName) {
        this.ExchangeName = ExchangeName;
    }

    /**
     * Get Sorting field.
MessageRateInOut specifies the total production and consumption rate.
MessageRateIn specifies the production rate.
MessageRateOut specifies the consumption rate. 
     * @return SortElement Sorting field.
MessageRateInOut specifies the total production and consumption rate.
MessageRateIn specifies the production rate.
MessageRateOut specifies the consumption rate.
     */
    public String getSortElement() {
        return this.SortElement;
    }

    /**
     * Set Sorting field.
MessageRateInOut specifies the total production and consumption rate.
MessageRateIn specifies the production rate.
MessageRateOut specifies the consumption rate.
     * @param SortElement Sorting field.
MessageRateInOut specifies the total production and consumption rate.
MessageRateIn specifies the production rate.
MessageRateOut specifies the consumption rate.
     */
    public void setSortElement(String SortElement) {
        this.SortElement = SortElement;
    }

    /**
     * Get Sort order. valid values: ascend or descend. 
     * @return SortOrder Sort order. valid values: ascend or descend.
     */
    public String getSortOrder() {
        return this.SortOrder;
    }

    /**
     * Set Sort order. valid values: ascend or descend.
     * @param SortOrder Sort order. valid values: ascend or descend.
     */
    public void setSortOrder(String SortOrder) {
        this.SortOrder = SortOrder;
    }

    public DescribeRabbitMQServerlessExchangesRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeRabbitMQServerlessExchangesRequest(DescribeRabbitMQServerlessExchangesRequest source) {
        if (source.InstanceId != null) {
            this.InstanceId = new String(source.InstanceId);
        }
        if (source.VirtualHost != null) {
            this.VirtualHost = new String(source.VirtualHost);
        }
        if (source.Offset != null) {
            this.Offset = new Long(source.Offset);
        }
        if (source.Limit != null) {
            this.Limit = new Long(source.Limit);
        }
        if (source.SearchWord != null) {
            this.SearchWord = new String(source.SearchWord);
        }
        if (source.ExchangeTypeFilters != null) {
            this.ExchangeTypeFilters = new String[source.ExchangeTypeFilters.length];
            for (int i = 0; i < source.ExchangeTypeFilters.length; i++) {
                this.ExchangeTypeFilters[i] = new String(source.ExchangeTypeFilters[i]);
            }
        }
        if (source.ExchangeCreatorFilters != null) {
            this.ExchangeCreatorFilters = new String[source.ExchangeCreatorFilters.length];
            for (int i = 0; i < source.ExchangeCreatorFilters.length; i++) {
                this.ExchangeCreatorFilters[i] = new String(source.ExchangeCreatorFilters[i]);
            }
        }
        if (source.ExchangeName != null) {
            this.ExchangeName = new String(source.ExchangeName);
        }
        if (source.SortElement != null) {
            this.SortElement = new String(source.SortElement);
        }
        if (source.SortOrder != null) {
            this.SortOrder = new String(source.SortOrder);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "InstanceId", this.InstanceId);
        this.setParamSimple(map, prefix + "VirtualHost", this.VirtualHost);
        this.setParamSimple(map, prefix + "Offset", this.Offset);
        this.setParamSimple(map, prefix + "Limit", this.Limit);
        this.setParamSimple(map, prefix + "SearchWord", this.SearchWord);
        this.setParamArraySimple(map, prefix + "ExchangeTypeFilters.", this.ExchangeTypeFilters);
        this.setParamArraySimple(map, prefix + "ExchangeCreatorFilters.", this.ExchangeCreatorFilters);
        this.setParamSimple(map, prefix + "ExchangeName", this.ExchangeName);
        this.setParamSimple(map, prefix + "SortElement", this.SortElement);
        this.setParamSimple(map, prefix + "SortOrder", this.SortOrder);

    }
}

