/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.trabbit.v20230418.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class RabbitMQExchangeListInfo extends AbstractModel {

    /**
    * exchange name.
    */
    @SerializedName("ExchangeName")
    @Expose
    private String ExchangeName;

    /**
    * Remarks.
    */
    @SerializedName("Remark")
    @Expose
    private String Remark;

    /**
    * Specifies the exchange type. valid values: "fanout", "direct", "topic", "headers".
    */
    @SerializedName("ExchangeType")
    @Expose
    private String ExchangeType;

    /**
    * VHost parameter.
    */
    @SerializedName("VirtualHost")
    @Expose
    private String VirtualHost;

    /**
    * exchange creator. valid values: `system` (generated by the system), `user` (user-created).
    */
    @SerializedName("ExchangeCreator")
    @Expose
    private String ExchangeCreator;

    /**
    * exchange creation time.
    */
    @SerializedName("CreateTimeStamp")
    @Expose
    private String CreateTimeStamp;

    /**
    * exchange modification time.
    */
    @SerializedName("ModTimeStamp")
    @Expose
    private String ModTimeStamp;

    /**
    * Input message rate.
    */
    @SerializedName("MessageRateIn")
    @Expose
    private Float MessageRateIn;

    /**
    * Output message rate.
    */
    @SerializedName("MessageRateOut")
    @Expose
    private Float MessageRateOut;

    /**
    * Specifies whether it is a persistent exchange. true indicates persistent, and false indicates non-persistent.
    */
    @SerializedName("Durable")
    @Expose
    private Boolean Durable;

    /**
    * Specifies whether to automatically delete the switch. true indicates automatic deletion, and false indicates non-automatic deletion.
    */
    @SerializedName("AutoDelete")
    @Expose
    private Boolean AutoDelete;

    /**
    * Whether it is an internal switch. valid values: true (indicating an internal switch).
    */
    @SerializedName("Internal")
    @Expose
    private Boolean Internal;

    /**
    * Specifies the ID of the associated instance to which the switch belongs.
    */
    @SerializedName("InstanceId")
    @Expose
    private String InstanceId;

    /**
    * The name of the effective policy.
    */
    @SerializedName("Policy")
    @Expose
    private String Policy;

    /**
    * Additional parameters key-value objects.
    */
    @SerializedName("Arguments")
    @Expose
    private String Arguments;

    /**
    * Number of unscheduled delayed messages.
    */
    @SerializedName("MessagesDelayed")
    @Expose
    private Long MessagesDelayed;

    /**
     * Get exchange name. 
     * @return ExchangeName exchange name.
     */
    public String getExchangeName() {
        return this.ExchangeName;
    }

    /**
     * Set exchange name.
     * @param ExchangeName exchange name.
     */
    public void setExchangeName(String ExchangeName) {
        this.ExchangeName = ExchangeName;
    }

    /**
     * Get Remarks. 
     * @return Remark Remarks.
     */
    public String getRemark() {
        return this.Remark;
    }

    /**
     * Set Remarks.
     * @param Remark Remarks.
     */
    public void setRemark(String Remark) {
        this.Remark = Remark;
    }

    /**
     * Get Specifies the exchange type. valid values: "fanout", "direct", "topic", "headers". 
     * @return ExchangeType Specifies the exchange type. valid values: "fanout", "direct", "topic", "headers".
     */
    public String getExchangeType() {
        return this.ExchangeType;
    }

    /**
     * Set Specifies the exchange type. valid values: "fanout", "direct", "topic", "headers".
     * @param ExchangeType Specifies the exchange type. valid values: "fanout", "direct", "topic", "headers".
     */
    public void setExchangeType(String ExchangeType) {
        this.ExchangeType = ExchangeType;
    }

    /**
     * Get VHost parameter. 
     * @return VirtualHost VHost parameter.
     */
    public String getVirtualHost() {
        return this.VirtualHost;
    }

    /**
     * Set VHost parameter.
     * @param VirtualHost VHost parameter.
     */
    public void setVirtualHost(String VirtualHost) {
        this.VirtualHost = VirtualHost;
    }

    /**
     * Get exchange creator. valid values: `system` (generated by the system), `user` (user-created). 
     * @return ExchangeCreator exchange creator. valid values: `system` (generated by the system), `user` (user-created).
     */
    public String getExchangeCreator() {
        return this.ExchangeCreator;
    }

    /**
     * Set exchange creator. valid values: `system` (generated by the system), `user` (user-created).
     * @param ExchangeCreator exchange creator. valid values: `system` (generated by the system), `user` (user-created).
     */
    public void setExchangeCreator(String ExchangeCreator) {
        this.ExchangeCreator = ExchangeCreator;
    }

    /**
     * Get exchange creation time. 
     * @return CreateTimeStamp exchange creation time.
     */
    public String getCreateTimeStamp() {
        return this.CreateTimeStamp;
    }

    /**
     * Set exchange creation time.
     * @param CreateTimeStamp exchange creation time.
     */
    public void setCreateTimeStamp(String CreateTimeStamp) {
        this.CreateTimeStamp = CreateTimeStamp;
    }

    /**
     * Get exchange modification time. 
     * @return ModTimeStamp exchange modification time.
     */
    public String getModTimeStamp() {
        return this.ModTimeStamp;
    }

    /**
     * Set exchange modification time.
     * @param ModTimeStamp exchange modification time.
     */
    public void setModTimeStamp(String ModTimeStamp) {
        this.ModTimeStamp = ModTimeStamp;
    }

    /**
     * Get Input message rate. 
     * @return MessageRateIn Input message rate.
     */
    public Float getMessageRateIn() {
        return this.MessageRateIn;
    }

    /**
     * Set Input message rate.
     * @param MessageRateIn Input message rate.
     */
    public void setMessageRateIn(Float MessageRateIn) {
        this.MessageRateIn = MessageRateIn;
    }

    /**
     * Get Output message rate. 
     * @return MessageRateOut Output message rate.
     */
    public Float getMessageRateOut() {
        return this.MessageRateOut;
    }

    /**
     * Set Output message rate.
     * @param MessageRateOut Output message rate.
     */
    public void setMessageRateOut(Float MessageRateOut) {
        this.MessageRateOut = MessageRateOut;
    }

    /**
     * Get Specifies whether it is a persistent exchange. true indicates persistent, and false indicates non-persistent. 
     * @return Durable Specifies whether it is a persistent exchange. true indicates persistent, and false indicates non-persistent.
     */
    public Boolean getDurable() {
        return this.Durable;
    }

    /**
     * Set Specifies whether it is a persistent exchange. true indicates persistent, and false indicates non-persistent.
     * @param Durable Specifies whether it is a persistent exchange. true indicates persistent, and false indicates non-persistent.
     */
    public void setDurable(Boolean Durable) {
        this.Durable = Durable;
    }

    /**
     * Get Specifies whether to automatically delete the switch. true indicates automatic deletion, and false indicates non-automatic deletion. 
     * @return AutoDelete Specifies whether to automatically delete the switch. true indicates automatic deletion, and false indicates non-automatic deletion.
     */
    public Boolean getAutoDelete() {
        return this.AutoDelete;
    }

    /**
     * Set Specifies whether to automatically delete the switch. true indicates automatic deletion, and false indicates non-automatic deletion.
     * @param AutoDelete Specifies whether to automatically delete the switch. true indicates automatic deletion, and false indicates non-automatic deletion.
     */
    public void setAutoDelete(Boolean AutoDelete) {
        this.AutoDelete = AutoDelete;
    }

    /**
     * Get Whether it is an internal switch. valid values: true (indicating an internal switch). 
     * @return Internal Whether it is an internal switch. valid values: true (indicating an internal switch).
     */
    public Boolean getInternal() {
        return this.Internal;
    }

    /**
     * Set Whether it is an internal switch. valid values: true (indicating an internal switch).
     * @param Internal Whether it is an internal switch. valid values: true (indicating an internal switch).
     */
    public void setInternal(Boolean Internal) {
        this.Internal = Internal;
    }

    /**
     * Get Specifies the ID of the associated instance to which the switch belongs. 
     * @return InstanceId Specifies the ID of the associated instance to which the switch belongs.
     */
    public String getInstanceId() {
        return this.InstanceId;
    }

    /**
     * Set Specifies the ID of the associated instance to which the switch belongs.
     * @param InstanceId Specifies the ID of the associated instance to which the switch belongs.
     */
    public void setInstanceId(String InstanceId) {
        this.InstanceId = InstanceId;
    }

    /**
     * Get The name of the effective policy. 
     * @return Policy The name of the effective policy.
     */
    public String getPolicy() {
        return this.Policy;
    }

    /**
     * Set The name of the effective policy.
     * @param Policy The name of the effective policy.
     */
    public void setPolicy(String Policy) {
        this.Policy = Policy;
    }

    /**
     * Get Additional parameters key-value objects. 
     * @return Arguments Additional parameters key-value objects.
     */
    public String getArguments() {
        return this.Arguments;
    }

    /**
     * Set Additional parameters key-value objects.
     * @param Arguments Additional parameters key-value objects.
     */
    public void setArguments(String Arguments) {
        this.Arguments = Arguments;
    }

    /**
     * Get Number of unscheduled delayed messages. 
     * @return MessagesDelayed Number of unscheduled delayed messages.
     */
    public Long getMessagesDelayed() {
        return this.MessagesDelayed;
    }

    /**
     * Set Number of unscheduled delayed messages.
     * @param MessagesDelayed Number of unscheduled delayed messages.
     */
    public void setMessagesDelayed(Long MessagesDelayed) {
        this.MessagesDelayed = MessagesDelayed;
    }

    public RabbitMQExchangeListInfo() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public RabbitMQExchangeListInfo(RabbitMQExchangeListInfo source) {
        if (source.ExchangeName != null) {
            this.ExchangeName = new String(source.ExchangeName);
        }
        if (source.Remark != null) {
            this.Remark = new String(source.Remark);
        }
        if (source.ExchangeType != null) {
            this.ExchangeType = new String(source.ExchangeType);
        }
        if (source.VirtualHost != null) {
            this.VirtualHost = new String(source.VirtualHost);
        }
        if (source.ExchangeCreator != null) {
            this.ExchangeCreator = new String(source.ExchangeCreator);
        }
        if (source.CreateTimeStamp != null) {
            this.CreateTimeStamp = new String(source.CreateTimeStamp);
        }
        if (source.ModTimeStamp != null) {
            this.ModTimeStamp = new String(source.ModTimeStamp);
        }
        if (source.MessageRateIn != null) {
            this.MessageRateIn = new Float(source.MessageRateIn);
        }
        if (source.MessageRateOut != null) {
            this.MessageRateOut = new Float(source.MessageRateOut);
        }
        if (source.Durable != null) {
            this.Durable = new Boolean(source.Durable);
        }
        if (source.AutoDelete != null) {
            this.AutoDelete = new Boolean(source.AutoDelete);
        }
        if (source.Internal != null) {
            this.Internal = new Boolean(source.Internal);
        }
        if (source.InstanceId != null) {
            this.InstanceId = new String(source.InstanceId);
        }
        if (source.Policy != null) {
            this.Policy = new String(source.Policy);
        }
        if (source.Arguments != null) {
            this.Arguments = new String(source.Arguments);
        }
        if (source.MessagesDelayed != null) {
            this.MessagesDelayed = new Long(source.MessagesDelayed);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ExchangeName", this.ExchangeName);
        this.setParamSimple(map, prefix + "Remark", this.Remark);
        this.setParamSimple(map, prefix + "ExchangeType", this.ExchangeType);
        this.setParamSimple(map, prefix + "VirtualHost", this.VirtualHost);
        this.setParamSimple(map, prefix + "ExchangeCreator", this.ExchangeCreator);
        this.setParamSimple(map, prefix + "CreateTimeStamp", this.CreateTimeStamp);
        this.setParamSimple(map, prefix + "ModTimeStamp", this.ModTimeStamp);
        this.setParamSimple(map, prefix + "MessageRateIn", this.MessageRateIn);
        this.setParamSimple(map, prefix + "MessageRateOut", this.MessageRateOut);
        this.setParamSimple(map, prefix + "Durable", this.Durable);
        this.setParamSimple(map, prefix + "AutoDelete", this.AutoDelete);
        this.setParamSimple(map, prefix + "Internal", this.Internal);
        this.setParamSimple(map, prefix + "InstanceId", this.InstanceId);
        this.setParamSimple(map, prefix + "Policy", this.Policy);
        this.setParamSimple(map, prefix + "Arguments", this.Arguments);
        this.setParamSimple(map, prefix + "MessagesDelayed", this.MessagesDelayed);

    }
}

