/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.trabbit.v20230418.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class RabbitMQQueueListConsumerDetailInfo extends AbstractModel {

    /**
    * Number of consumers.
    */
    @SerializedName("ConsumersNumber")
    @Expose
    private Long ConsumersNumber;

    /**
     * Get Number of consumers. 
     * @return ConsumersNumber Number of consumers.
     */
    public Long getConsumersNumber() {
        return this.ConsumersNumber;
    }

    /**
     * Set Number of consumers.
     * @param ConsumersNumber Number of consumers.
     */
    public void setConsumersNumber(Long ConsumersNumber) {
        this.ConsumersNumber = ConsumersNumber;
    }

    public RabbitMQQueueListConsumerDetailInfo() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public RabbitMQQueueListConsumerDetailInfo(RabbitMQQueueListConsumerDetailInfo source) {
        if (source.ConsumersNumber != null) {
            this.ConsumersNumber = new Long(source.ConsumersNumber);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ConsumersNumber", this.ConsumersNumber);

    }
}

