/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.trro.v20220325.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeProjectListResponse extends AbstractModel {

    /**
    * Array of project information.
    */
    @SerializedName("Projects")
    @Expose
    private ProjectInfo [] Projects;

    /**
    * Total number of projects.
    */
    @SerializedName("Total")
    @Expose
    private Long Total;

    /**
    * Number of projects returned in this request.
    */
    @SerializedName("Num")
    @Expose
    private Long Num;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Array of project information. 
     * @return Projects Array of project information.
     */
    public ProjectInfo [] getProjects() {
        return this.Projects;
    }

    /**
     * Set Array of project information.
     * @param Projects Array of project information.
     */
    public void setProjects(ProjectInfo [] Projects) {
        this.Projects = Projects;
    }

    /**
     * Get Total number of projects. 
     * @return Total Total number of projects.
     */
    public Long getTotal() {
        return this.Total;
    }

    /**
     * Set Total number of projects.
     * @param Total Total number of projects.
     */
    public void setTotal(Long Total) {
        this.Total = Total;
    }

    /**
     * Get Number of projects returned in this request. 
     * @return Num Number of projects returned in this request.
     */
    public Long getNum() {
        return this.Num;
    }

    /**
     * Set Number of projects returned in this request.
     * @param Num Number of projects returned in this request.
     */
    public void setNum(Long Num) {
        this.Num = Num;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeProjectListResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeProjectListResponse(DescribeProjectListResponse source) {
        if (source.Projects != null) {
            this.Projects = new ProjectInfo[source.Projects.length];
            for (int i = 0; i < source.Projects.length; i++) {
                this.Projects[i] = new ProjectInfo(source.Projects[i]);
            }
        }
        if (source.Total != null) {
            this.Total = new Long(source.Total);
        }
        if (source.Num != null) {
            this.Num = new Long(source.Num);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Projects.", this.Projects);
        this.setParamSimple(map, prefix + "Total", this.Total);
        this.setParamSimple(map, prefix + "Num", this.Num);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

