/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.trro.v20220325.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GetLicenseStatResponse extends AbstractModel {

    /**
    * Valid authorization.
    */
    @SerializedName("Valid")
    @Expose
    private Long Valid;

    /**
    * Bound authorization.
    */
    @SerializedName("Bound")
    @Expose
    private Long Bound;

    /**
    * Unbound authorization.
    */
    @SerializedName("UnBound")
    @Expose
    private Long UnBound;

    /**
    * Expired authorization.
    */
    @SerializedName("Expire")
    @Expose
    private Long Expire;

    /**
    * Number of authorization timeouts for the current month.
    */
    @SerializedName("MonthlyExpire")
    @Expose
    private Long MonthlyExpire;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Valid authorization. 
     * @return Valid Valid authorization.
     */
    public Long getValid() {
        return this.Valid;
    }

    /**
     * Set Valid authorization.
     * @param Valid Valid authorization.
     */
    public void setValid(Long Valid) {
        this.Valid = Valid;
    }

    /**
     * Get Bound authorization. 
     * @return Bound Bound authorization.
     */
    public Long getBound() {
        return this.Bound;
    }

    /**
     * Set Bound authorization.
     * @param Bound Bound authorization.
     */
    public void setBound(Long Bound) {
        this.Bound = Bound;
    }

    /**
     * Get Unbound authorization. 
     * @return UnBound Unbound authorization.
     */
    public Long getUnBound() {
        return this.UnBound;
    }

    /**
     * Set Unbound authorization.
     * @param UnBound Unbound authorization.
     */
    public void setUnBound(Long UnBound) {
        this.UnBound = UnBound;
    }

    /**
     * Get Expired authorization. 
     * @return Expire Expired authorization.
     */
    public Long getExpire() {
        return this.Expire;
    }

    /**
     * Set Expired authorization.
     * @param Expire Expired authorization.
     */
    public void setExpire(Long Expire) {
        this.Expire = Expire;
    }

    /**
     * Get Number of authorization timeouts for the current month. 
     * @return MonthlyExpire Number of authorization timeouts for the current month.
     */
    public Long getMonthlyExpire() {
        return this.MonthlyExpire;
    }

    /**
     * Set Number of authorization timeouts for the current month.
     * @param MonthlyExpire Number of authorization timeouts for the current month.
     */
    public void setMonthlyExpire(Long MonthlyExpire) {
        this.MonthlyExpire = MonthlyExpire;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public GetLicenseStatResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GetLicenseStatResponse(GetLicenseStatResponse source) {
        if (source.Valid != null) {
            this.Valid = new Long(source.Valid);
        }
        if (source.Bound != null) {
            this.Bound = new Long(source.Bound);
        }
        if (source.UnBound != null) {
            this.UnBound = new Long(source.UnBound);
        }
        if (source.Expire != null) {
            this.Expire = new Long(source.Expire);
        }
        if (source.MonthlyExpire != null) {
            this.MonthlyExpire = new Long(source.MonthlyExpire);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Valid", this.Valid);
        this.setParamSimple(map, prefix + "Bound", this.Bound);
        this.setParamSimple(map, prefix + "UnBound", this.UnBound);
        this.setParamSimple(map, prefix + "Expire", this.Expire);
        this.setParamSimple(map, prefix + "MonthlyExpire", this.MonthlyExpire);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

