/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.trro.v20220325.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ModifyPolicyResponse extends AbstractModel {

    /**
    * List of on-site device ids with association failed.
    */
    @SerializedName("FailedInsertIds")
    @Expose
    private String [] FailedInsertIds;

    /**
    * List of on-site device ids with disassociation failed.
    */
    @SerializedName("FailedDeleteIds")
    @Expose
    private String [] FailedDeleteIds;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get List of on-site device ids with association failed. 
     * @return FailedInsertIds List of on-site device ids with association failed.
     */
    public String [] getFailedInsertIds() {
        return this.FailedInsertIds;
    }

    /**
     * Set List of on-site device ids with association failed.
     * @param FailedInsertIds List of on-site device ids with association failed.
     */
    public void setFailedInsertIds(String [] FailedInsertIds) {
        this.FailedInsertIds = FailedInsertIds;
    }

    /**
     * Get List of on-site device ids with disassociation failed. 
     * @return FailedDeleteIds List of on-site device ids with disassociation failed.
     */
    public String [] getFailedDeleteIds() {
        return this.FailedDeleteIds;
    }

    /**
     * Set List of on-site device ids with disassociation failed.
     * @param FailedDeleteIds List of on-site device ids with disassociation failed.
     */
    public void setFailedDeleteIds(String [] FailedDeleteIds) {
        this.FailedDeleteIds = FailedDeleteIds;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public ModifyPolicyResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ModifyPolicyResponse(ModifyPolicyResponse source) {
        if (source.FailedInsertIds != null) {
            this.FailedInsertIds = new String[source.FailedInsertIds.length];
            for (int i = 0; i < source.FailedInsertIds.length; i++) {
                this.FailedInsertIds[i] = new String(source.FailedInsertIds[i]);
            }
        }
        if (source.FailedDeleteIds != null) {
            this.FailedDeleteIds = new String[source.FailedDeleteIds.length];
            for (int i = 0; i < source.FailedDeleteIds.length; i++) {
                this.FailedDeleteIds[i] = new String(source.FailedDeleteIds[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "FailedInsertIds.", this.FailedInsertIds);
        this.setParamArraySimple(map, prefix + "FailedDeleteIds.", this.FailedDeleteIds);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

