/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.vclm.v20240523.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeImageAnimateJobResponse extends AbstractModel {

    /**
    * Task status. WAIT: waiting; RUN: running; FAIL: failed; DONE: successful.
    */
    @SerializedName("Status")
    @Expose
    private String Status;

    /**
    * Error code.
    */
    @SerializedName("ErrorCode")
    @Expose
    private String ErrorCode;

    /**
    * Error message.
    */
    @SerializedName("ErrorMessage")
    @Expose
    private String ErrorMessage;

    /**
    * Generated video URL. It is valid for 24 hours.
    */
    @SerializedName("ResultVideoUrl")
    @Expose
    private String ResultVideoUrl;

    /**
    * Masked video URL.
    */
    @SerializedName("MaskVideoUrl")
    @Expose
    private String MaskVideoUrl;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Task status. WAIT: waiting; RUN: running; FAIL: failed; DONE: successful. 
     * @return Status Task status. WAIT: waiting; RUN: running; FAIL: failed; DONE: successful.
     */
    public String getStatus() {
        return this.Status;
    }

    /**
     * Set Task status. WAIT: waiting; RUN: running; FAIL: failed; DONE: successful.
     * @param Status Task status. WAIT: waiting; RUN: running; FAIL: failed; DONE: successful.
     */
    public void setStatus(String Status) {
        this.Status = Status;
    }

    /**
     * Get Error code. 
     * @return ErrorCode Error code.
     */
    public String getErrorCode() {
        return this.ErrorCode;
    }

    /**
     * Set Error code.
     * @param ErrorCode Error code.
     */
    public void setErrorCode(String ErrorCode) {
        this.ErrorCode = ErrorCode;
    }

    /**
     * Get Error message. 
     * @return ErrorMessage Error message.
     */
    public String getErrorMessage() {
        return this.ErrorMessage;
    }

    /**
     * Set Error message.
     * @param ErrorMessage Error message.
     */
    public void setErrorMessage(String ErrorMessage) {
        this.ErrorMessage = ErrorMessage;
    }

    /**
     * Get Generated video URL. It is valid for 24 hours. 
     * @return ResultVideoUrl Generated video URL. It is valid for 24 hours.
     */
    public String getResultVideoUrl() {
        return this.ResultVideoUrl;
    }

    /**
     * Set Generated video URL. It is valid for 24 hours.
     * @param ResultVideoUrl Generated video URL. It is valid for 24 hours.
     */
    public void setResultVideoUrl(String ResultVideoUrl) {
        this.ResultVideoUrl = ResultVideoUrl;
    }

    /**
     * Get Masked video URL. 
     * @return MaskVideoUrl Masked video URL.
     */
    public String getMaskVideoUrl() {
        return this.MaskVideoUrl;
    }

    /**
     * Set Masked video URL.
     * @param MaskVideoUrl Masked video URL.
     */
    public void setMaskVideoUrl(String MaskVideoUrl) {
        this.MaskVideoUrl = MaskVideoUrl;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeImageAnimateJobResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeImageAnimateJobResponse(DescribeImageAnimateJobResponse source) {
        if (source.Status != null) {
            this.Status = new String(source.Status);
        }
        if (source.ErrorCode != null) {
            this.ErrorCode = new String(source.ErrorCode);
        }
        if (source.ErrorMessage != null) {
            this.ErrorMessage = new String(source.ErrorMessage);
        }
        if (source.ResultVideoUrl != null) {
            this.ResultVideoUrl = new String(source.ResultVideoUrl);
        }
        if (source.MaskVideoUrl != null) {
            this.MaskVideoUrl = new String(source.MaskVideoUrl);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "ErrorCode", this.ErrorCode);
        this.setParamSimple(map, prefix + "ErrorMessage", this.ErrorMessage);
        this.setParamSimple(map, prefix + "ResultVideoUrl", this.ResultVideoUrl);
        this.setParamSimple(map, prefix + "MaskVideoUrl", this.MaskVideoUrl);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

