/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.vod.v20180717.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class LiveRealTimeClipResponse extends AbstractModel {

    /**
    * Playback URL of clipped video.
    */
    @SerializedName("Url")
    @Expose
    private String Url;

    /**
    * Unique media file ID of video generated by persistent clipping.
Note: this field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("FileId")
    @Expose
    private String FileId;

    /**
    * Task flow ID of video generated by persistent clipping.
Note: this field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("VodTaskId")
    @Expose
    private String VodTaskId;

    /**
    * 
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("MetaData")
    @Expose
    private MediaMetaData MetaData;

    /**
    * Cliped media segment info.
    */
    @SerializedName("SegmentSet")
    @Expose
    private LiveRealTimeClipMediaSegmentInfo [] SegmentSet;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Playback URL of clipped video. 
     * @return Url Playback URL of clipped video.
     */
    public String getUrl() {
        return this.Url;
    }

    /**
     * Set Playback URL of clipped video.
     * @param Url Playback URL of clipped video.
     */
    public void setUrl(String Url) {
        this.Url = Url;
    }

    /**
     * Get Unique media file ID of video generated by persistent clipping.
Note: this field may return null, indicating that no valid values can be obtained. 
     * @return FileId Unique media file ID of video generated by persistent clipping.
Note: this field may return null, indicating that no valid values can be obtained.
     */
    public String getFileId() {
        return this.FileId;
    }

    /**
     * Set Unique media file ID of video generated by persistent clipping.
Note: this field may return null, indicating that no valid values can be obtained.
     * @param FileId Unique media file ID of video generated by persistent clipping.
Note: this field may return null, indicating that no valid values can be obtained.
     */
    public void setFileId(String FileId) {
        this.FileId = FileId;
    }

    /**
     * Get Task flow ID of video generated by persistent clipping.
Note: this field may return null, indicating that no valid values can be obtained. 
     * @return VodTaskId Task flow ID of video generated by persistent clipping.
Note: this field may return null, indicating that no valid values can be obtained.
     */
    public String getVodTaskId() {
        return this.VodTaskId;
    }

    /**
     * Set Task flow ID of video generated by persistent clipping.
Note: this field may return null, indicating that no valid values can be obtained.
     * @param VodTaskId Task flow ID of video generated by persistent clipping.
Note: this field may return null, indicating that no valid values can be obtained.
     */
    public void setVodTaskId(String VodTaskId) {
        this.VodTaskId = VodTaskId;
    }

    /**
     * Get 
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return MetaData 
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public MediaMetaData getMetaData() {
        return this.MetaData;
    }

    /**
     * Set 
Note: This field may return null, indicating that no valid value can be obtained.
     * @param MetaData 
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setMetaData(MediaMetaData MetaData) {
        this.MetaData = MetaData;
    }

    /**
     * Get Cliped media segment info. 
     * @return SegmentSet Cliped media segment info.
     */
    public LiveRealTimeClipMediaSegmentInfo [] getSegmentSet() {
        return this.SegmentSet;
    }

    /**
     * Set Cliped media segment info.
     * @param SegmentSet Cliped media segment info.
     */
    public void setSegmentSet(LiveRealTimeClipMediaSegmentInfo [] SegmentSet) {
        this.SegmentSet = SegmentSet;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public LiveRealTimeClipResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public LiveRealTimeClipResponse(LiveRealTimeClipResponse source) {
        if (source.Url != null) {
            this.Url = new String(source.Url);
        }
        if (source.FileId != null) {
            this.FileId = new String(source.FileId);
        }
        if (source.VodTaskId != null) {
            this.VodTaskId = new String(source.VodTaskId);
        }
        if (source.MetaData != null) {
            this.MetaData = new MediaMetaData(source.MetaData);
        }
        if (source.SegmentSet != null) {
            this.SegmentSet = new LiveRealTimeClipMediaSegmentInfo[source.SegmentSet.length];
            for (int i = 0; i < source.SegmentSet.length; i++) {
                this.SegmentSet[i] = new LiveRealTimeClipMediaSegmentInfo(source.SegmentSet[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Url", this.Url);
        this.setParamSimple(map, prefix + "FileId", this.FileId);
        this.setParamSimple(map, prefix + "VodTaskId", this.VodTaskId);
        this.setParamObj(map, prefix + "MetaData.", this.MetaData);
        this.setParamArrayObj(map, prefix + "SegmentSet.", this.SegmentSet);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

