/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.vod.v20180717.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class MediaTransitionItem extends AbstractModel {

    /**
    * Transition duration in seconds. For two media segments that use a transition, the start time of the second segment on the track will be automatically set to the end time of the first segment minus the transition duration.
    */
    @SerializedName("Duration")
    @Expose
    private Float Duration;

    /**
    * List of transition operations. Up to one video image or audio transition operation is supported.
Note: this field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Transitions")
    @Expose
    private TransitionOpertion [] Transitions;

    /**
    * Transition operation list. Image transition operations and audio transition operations support at most one each.
    */
    @SerializedName("MediaTransitions")
    @Expose
    private TransitionOperation [] MediaTransitions;

    /**
     * Get Transition duration in seconds. For two media segments that use a transition, the start time of the second segment on the track will be automatically set to the end time of the first segment minus the transition duration. 
     * @return Duration Transition duration in seconds. For two media segments that use a transition, the start time of the second segment on the track will be automatically set to the end time of the first segment minus the transition duration.
     */
    public Float getDuration() {
        return this.Duration;
    }

    /**
     * Set Transition duration in seconds. For two media segments that use a transition, the start time of the second segment on the track will be automatically set to the end time of the first segment minus the transition duration.
     * @param Duration Transition duration in seconds. For two media segments that use a transition, the start time of the second segment on the track will be automatically set to the end time of the first segment minus the transition duration.
     */
    public void setDuration(Float Duration) {
        this.Duration = Duration;
    }

    /**
     * Get List of transition operations. Up to one video image or audio transition operation is supported.
Note: this field may return null, indicating that no valid values can be obtained. 
     * @return Transitions List of transition operations. Up to one video image or audio transition operation is supported.
Note: this field may return null, indicating that no valid values can be obtained.
     * @deprecated
     */
    @Deprecated
    public TransitionOpertion [] getTransitions() {
        return this.Transitions;
    }

    /**
     * Set List of transition operations. Up to one video image or audio transition operation is supported.
Note: this field may return null, indicating that no valid values can be obtained.
     * @param Transitions List of transition operations. Up to one video image or audio transition operation is supported.
Note: this field may return null, indicating that no valid values can be obtained.
     * @deprecated
     */
    @Deprecated
    public void setTransitions(TransitionOpertion [] Transitions) {
        this.Transitions = Transitions;
    }

    /**
     * Get Transition operation list. Image transition operations and audio transition operations support at most one each. 
     * @return MediaTransitions Transition operation list. Image transition operations and audio transition operations support at most one each.
     */
    public TransitionOperation [] getMediaTransitions() {
        return this.MediaTransitions;
    }

    /**
     * Set Transition operation list. Image transition operations and audio transition operations support at most one each.
     * @param MediaTransitions Transition operation list. Image transition operations and audio transition operations support at most one each.
     */
    public void setMediaTransitions(TransitionOperation [] MediaTransitions) {
        this.MediaTransitions = MediaTransitions;
    }

    public MediaTransitionItem() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public MediaTransitionItem(MediaTransitionItem source) {
        if (source.Duration != null) {
            this.Duration = new Float(source.Duration);
        }
        if (source.Transitions != null) {
            this.Transitions = new TransitionOpertion[source.Transitions.length];
            for (int i = 0; i < source.Transitions.length; i++) {
                this.Transitions[i] = new TransitionOpertion(source.Transitions[i]);
            }
        }
        if (source.MediaTransitions != null) {
            this.MediaTransitions = new TransitionOperation[source.MediaTransitions.length];
            for (int i = 0; i < source.MediaTransitions.length; i++) {
                this.MediaTransitions[i] = new TransitionOperation(source.MediaTransitions[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Duration", this.Duration);
        this.setParamArrayObj(map, prefix + "Transitions.", this.Transitions);
        this.setParamArrayObj(map, prefix + "MediaTransitions.", this.MediaTransitions);

    }
}

