/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.vpc.v20170312.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class AddressTemplate extends AbstractModel {

    /**
    * IP address template name.
    */
    @SerializedName("AddressTemplateName")
    @Expose
    private String AddressTemplateName;

    /**
    * The unique ID of the IP address template instance.
    */
    @SerializedName("AddressTemplateId")
    @Expose
    private String AddressTemplateId;

    /**
    * IP address information.
    */
    @SerializedName("AddressSet")
    @Expose
    private String [] AddressSet;

    /**
    * Creation Time.
    */
    @SerializedName("CreatedTime")
    @Expose
    private String CreatedTime;

    /**
    * IP address information with remarks
    */
    @SerializedName("AddressExtraSet")
    @Expose
    private AddressInfo [] AddressExtraSet;

    /**
     * Get IP address template name. 
     * @return AddressTemplateName IP address template name.
     */
    public String getAddressTemplateName() {
        return this.AddressTemplateName;
    }

    /**
     * Set IP address template name.
     * @param AddressTemplateName IP address template name.
     */
    public void setAddressTemplateName(String AddressTemplateName) {
        this.AddressTemplateName = AddressTemplateName;
    }

    /**
     * Get The unique ID of the IP address template instance. 
     * @return AddressTemplateId The unique ID of the IP address template instance.
     */
    public String getAddressTemplateId() {
        return this.AddressTemplateId;
    }

    /**
     * Set The unique ID of the IP address template instance.
     * @param AddressTemplateId The unique ID of the IP address template instance.
     */
    public void setAddressTemplateId(String AddressTemplateId) {
        this.AddressTemplateId = AddressTemplateId;
    }

    /**
     * Get IP address information. 
     * @return AddressSet IP address information.
     */
    public String [] getAddressSet() {
        return this.AddressSet;
    }

    /**
     * Set IP address information.
     * @param AddressSet IP address information.
     */
    public void setAddressSet(String [] AddressSet) {
        this.AddressSet = AddressSet;
    }

    /**
     * Get Creation Time. 
     * @return CreatedTime Creation Time.
     */
    public String getCreatedTime() {
        return this.CreatedTime;
    }

    /**
     * Set Creation Time.
     * @param CreatedTime Creation Time.
     */
    public void setCreatedTime(String CreatedTime) {
        this.CreatedTime = CreatedTime;
    }

    /**
     * Get IP address information with remarks 
     * @return AddressExtraSet IP address information with remarks
     */
    public AddressInfo [] getAddressExtraSet() {
        return this.AddressExtraSet;
    }

    /**
     * Set IP address information with remarks
     * @param AddressExtraSet IP address information with remarks
     */
    public void setAddressExtraSet(AddressInfo [] AddressExtraSet) {
        this.AddressExtraSet = AddressExtraSet;
    }

    public AddressTemplate() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public AddressTemplate(AddressTemplate source) {
        if (source.AddressTemplateName != null) {
            this.AddressTemplateName = new String(source.AddressTemplateName);
        }
        if (source.AddressTemplateId != null) {
            this.AddressTemplateId = new String(source.AddressTemplateId);
        }
        if (source.AddressSet != null) {
            this.AddressSet = new String[source.AddressSet.length];
            for (int i = 0; i < source.AddressSet.length; i++) {
                this.AddressSet[i] = new String(source.AddressSet[i]);
            }
        }
        if (source.CreatedTime != null) {
            this.CreatedTime = new String(source.CreatedTime);
        }
        if (source.AddressExtraSet != null) {
            this.AddressExtraSet = new AddressInfo[source.AddressExtraSet.length];
            for (int i = 0; i < source.AddressExtraSet.length; i++) {
                this.AddressExtraSet[i] = new AddressInfo(source.AddressExtraSet[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "AddressTemplateName", this.AddressTemplateName);
        this.setParamSimple(map, prefix + "AddressTemplateId", this.AddressTemplateId);
        this.setParamArraySimple(map, prefix + "AddressSet.", this.AddressSet);
        this.setParamSimple(map, prefix + "CreatedTime", this.CreatedTime);
        this.setParamArrayObj(map, prefix + "AddressExtraSet.", this.AddressExtraSet);

    }
}

