/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.vpc.v20170312.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class InquirePriceCreateDirectConnectGatewayResponse extends AbstractModel {

    /**
    * Standard access fee for a direct connect gateway
Note: this field may return `null`, indicating that no valid values can be obtained.
    */
    @SerializedName("TotalCost")
    @Expose
    private Long TotalCost;

    /**
    * Actual access fee for a direct connect gateway
Note: this field may return `null`, indicating that no valid values can be obtained.
    */
    @SerializedName("RealTotalCost")
    @Expose
    private Long RealTotalCost;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Standard access fee for a direct connect gateway
Note: this field may return `null`, indicating that no valid values can be obtained. 
     * @return TotalCost Standard access fee for a direct connect gateway
Note: this field may return `null`, indicating that no valid values can be obtained.
     */
    public Long getTotalCost() {
        return this.TotalCost;
    }

    /**
     * Set Standard access fee for a direct connect gateway
Note: this field may return `null`, indicating that no valid values can be obtained.
     * @param TotalCost Standard access fee for a direct connect gateway
Note: this field may return `null`, indicating that no valid values can be obtained.
     */
    public void setTotalCost(Long TotalCost) {
        this.TotalCost = TotalCost;
    }

    /**
     * Get Actual access fee for a direct connect gateway
Note: this field may return `null`, indicating that no valid values can be obtained. 
     * @return RealTotalCost Actual access fee for a direct connect gateway
Note: this field may return `null`, indicating that no valid values can be obtained.
     */
    public Long getRealTotalCost() {
        return this.RealTotalCost;
    }

    /**
     * Set Actual access fee for a direct connect gateway
Note: this field may return `null`, indicating that no valid values can be obtained.
     * @param RealTotalCost Actual access fee for a direct connect gateway
Note: this field may return `null`, indicating that no valid values can be obtained.
     */
    public void setRealTotalCost(Long RealTotalCost) {
        this.RealTotalCost = RealTotalCost;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public InquirePriceCreateDirectConnectGatewayResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public InquirePriceCreateDirectConnectGatewayResponse(InquirePriceCreateDirectConnectGatewayResponse source) {
        if (source.TotalCost != null) {
            this.TotalCost = new Long(source.TotalCost);
        }
        if (source.RealTotalCost != null) {
            this.RealTotalCost = new Long(source.RealTotalCost);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCost", this.TotalCost);
        this.setParamSimple(map, prefix + "RealTotalCost", this.RealTotalCost);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

